<?php /** @noinspection PhpUnhandledExceptionInspection */


namespace Gek\Infrastructure\Math\DecimalExpressions;


use Gek\Infrastructure\Math\Decimal;

class DecimalModExpression extends DecimalExpression
{

    public ?DecimalExpression $left;
    public ?DecimalExpression $right;

    public function __construct(?DecimalExpression $left = null, ?DecimalExpression $right = null)
    {
        $this->left = $left;
        $this->right = $right;
    }


    /**
     * @inheritDoc
     */
    public function calculateValue(): Decimal
    {
        return $this->left->calculateValue()->mod($this->right->calculateValue());
    }
}