<?php


namespace Gek\Infrastructure\FlagExp;


/**
 * Class BitwiseNotExpression
 * @package Gek\Infrastructure\FlagExp
 */
class BitwiseNotExpression extends FlagExpression
{
    public ?FlagExpression $right;

    /**
     * BitwiseNotExpression constructor.
     * @param FlagExpression|null $right
     */
    public function __construct(?FlagExpression $right = null)
    {
        $this->right = $right;
    }

    /**
     * @return int
     */
    public function calculateValue(): int
    {
        return ~$this->right->calculateValue();
    }
}
