<?php


namespace Gek\Infrastructure;


use ReflectionException;

/**
 * Class FlagEnum
 * @package Gek\Infrastructure
 */
abstract class FlagEnum extends Enum
{

    /**
     * @return int
     * @throws ReflectionException
     */
    public static function allFlags(): int
    {
        $flags = parent::getEnumValues();
        $all = 0;
        foreach ($flags as $flag) {
            $all |= $flag;
        }
        return $all;
    }

}
