<?php


namespace Gek\Infrastructure;


use Gek\Infrastructure\Exceptions\InvalidArgumentException;
use Gek\Infrastructure\Exceptions\NotImplementedException;
use ReflectionException;

abstract class ConstClassType extends ConstClass
{
    private $value;

    /**
     * ConstClassType constructor.
     * @param mixed $value
     * @throws InvalidArgumentException
     * @throws ReflectionException
     */
    public function __construct($value)
    {
        $this->setValue($value);
    }

    /**
     * @param $name
     * @param $arguments
     * @return mixed
     * @throws NotImplementedException
     * @throws ReflectionException
     */
    public static function __callStatic($name, $arguments)
    {
        if (self::checkConstKey($name)) {
            $class = get_called_class();
            return new $class($name);
        }
        throw new NotImplementedException();
    }

    /**
     * @return mixed
     */
    public function getValue()
    {
        return $this->value;
    }

    /**
     * @param mixed $val
     * @throws InvalidArgumentException
     * @throws ReflectionException
     * @throws InvalidArgumentException
     */
    public function setValue($val): void
    {
        if (!static::checkConstValue($val) && !static::checkConstKey($val)) {
            throw new InvalidArgumentException(
                Str::format('Set edilmeye çalışılan değer ("{0}") {1} tipinin değerleri / anahtarları arasında bulunamadı.', $val, get_called_class()),
                0,
                null,
                '$val'
            );
        }
        if (static::checkConstValue($val)) {
            $this->value = $val;
        } else {
            $this->value = self::getConstValue($val);
        }

    }

    /**
     * @return string
     * @throws ReflectionException
     */
    public function __toString()
    {
        $values = self::getConstValues();
        foreach ($values as $key => $val) {
            if ($this->value === $val) {
                return $key;
            }
        }
        return '';
    }

}