<?php


namespace Gek\Infrastructure;

use Gek\Infrastructure\Exceptions\InvalidArgumentException;
use Gek\Infrastructure\Reflections\DocCommentObject;
use ReflectionClass;
use ReflectionClassConstant;
use ReflectionException;
use ReflectionFunction;
use ReflectionMethod;
use ReflectionObject;
use ReflectionProperty;
use Reflector;

/**
 * Class ClassHelper
 * @package Gek\Infrastructure
 */
class ClassHelper
{

    /**
     * @param Reflector $reflection
     * @return DocCommentObject
     * @throws InvalidArgumentException
     */
    public static function getDocCommentObject(Reflector $reflection): DocCommentObject
    {
        if ($reflection instanceof ReflectionClass) {
            return DocCommentObject::parse($reflection->getDocComment());
        }
        if ($reflection instanceof ReflectionFunction) {
            return DocCommentObject::parse($reflection->getDocComment());
        }
        if ($reflection instanceof ReflectionMethod) {
            return DocCommentObject::parse($reflection->getDocComment());
        }
        if ($reflection instanceof ReflectionObject) {
            return DocCommentObject::parse($reflection->getDocComment());
        }
        if ($reflection instanceof ReflectionProperty) {
            return DocCommentObject::parse($reflection->getDocComment());
        }
        if ($reflection instanceof ReflectionClassConstant) {
            return DocCommentObject::parse($reflection->getDocComment());
        }

        throw new InvalidArgumentException('$reflection desteklenmeyen Reflection tipi.');
    }


    /**
     * @param object $obj
     * @return object
     * @throws InvalidArgumentException
     */
    public static function getMetaObject(object $obj): object
    {
        $reflected = new ReflectionObject($obj);
        return self::createMetaObject($reflected);
    }

    /**
     * @param Reflector $reflected
     * @return object
     * @throws InvalidArgumentException
     */
    private static function createMetaObject(Reflector $reflected): object
    {
        if (($reflected instanceof ReflectionObject) || ($reflected instanceof ReflectionClass)) {
            $reflectedProperties = $reflected->getProperties(ReflectionProperty::IS_PUBLIC);
            $meta = array();
            foreach ($reflectedProperties as $propReflect) {
                $propName = $propReflect->getName();
                $meta[$propName] = $propName;
            }
            return (object)$meta;
        } else {
            throw new InvalidArgumentException('$reflected geçerli bir ReflectionObject veya ReflectionClass nesnesi değil!');
        }
    }

    /**
     * @param string $className
     * @return object
     * @throws InvalidArgumentException
     * @throws ReflectionException
     */
    public static function getMetaObjectClassName(string $className): object
    {
        $reflected = new ReflectionClass($className);
        return self::createMetaObject($reflected);
    }

    /**
     * @param object $obj
     * @return ReflectionObject
     */
    public static function reflectObject(object $obj): ReflectionObject
    {
        return new ReflectionObject($obj);
    }



    #region utils

    /**
     * @param string $className
     * @return ReflectionClass
     * @throws ReflectionException
     */
    public static function reflectClass(string $className): ReflectionClass
    {
        return new ReflectionClass($className);
    }

    #endregion utils

}
