<?php


namespace Gek\Infrastructure;

use Gek\Infrastructure\Reflections\DocCommentObject;
use ReflectionException;

/**
 * Class Enum
 * @package Gek\Infrastructure
 */
abstract class Enum
{


    private static $constArray = array();

    private static $docComArray = array();

    /**
     * @param string $key
     * @return mixed|null
     * @throws ReflectionException
     */
    public static function getEnumValue(string $key):?int
    {
        $constants = self::getEnumValues();
        return isset($constants[$key]) ? $constants[$key] : null;
    }

    /**
     * @return array|array<string,int>|int[]
     * @throws ReflectionException
     */
    public static function getEnumValues():array
    {
        $className = get_called_class();
        $constants = self::getConstantsArray($className);
        return $constants;
    }

    /**
     * @param string $key
     * @return bool
     * @throws ReflectionException
     */
    public static function checkEnumKey(string $key): bool
    {
        $constants = self::getEnumValues();
        return isset($constants[$key]);
    }

    /**
     * @param int $value
     * @return bool
     * @throws ReflectionException
     */
    public static function checkEnumValue(int $value): bool
    {
        $constants = self::getEnumValues();
        return in_array($value, $constants, true);
    }

    /**
     * @return array<string,DocCommentObject>|DocCommentObject[]
     * @throws ReflectionException
     */
    public static function getEnumDocComentObjects(): array
    {
        $className = get_called_class();
        if (!isset(self::$docComArray[$className])) {
            $reflect = ClassHelper::reflectClass($className);
            $reflectConstArray = $reflect->getReflectionConstants();
            $docComArr = array();
            foreach ($reflectConstArray as $refConst) {
                $docComArr[$refConst->getName()] = DocCommentObject::parse($refConst->getDocComment());
            }

            self::$docComArray[$className] = $docComArr;
        }
        return self::$docComArray[$className];

    }

    /**
     * @param string $className
     * @return array
     * @throws ReflectionException
     */
    private static function getConstantsArray(string $className): array
    {
        if (!isset(self::$constArray[$className])) {
            $reflect = ClassHelper::reflectClass($className);
            self::$constArray[$className] = $reflect->getConstants();
        }
        return self::$constArray[$className];
    }


}
