<?php


namespace Gek\Infrastructure;



use Gek\Infrastructure\Reflections\DocCommentObject;
use ReflectionException;

abstract class ConstClass
{

    private static $constArray = array();

    private static $docComArray = array();

    /**
     * @param string $key
     * @return mixed|null
     * @throws ReflectionException
     */
    public static function getConstValue(string $key)
    {
        $constants = self::getConstValues();
        return isset($constants[$key]) ? $constants[$key] : null;
    }

    /**
     * @return array
     * @throws ReflectionException
     */
    public static function getConstValues()
    {
        $className = get_called_class();
        $constants = self::getConstantsArray($className);
        return $constants;
    }

    /**
     * @param string $key
     * @return bool
     * @throws ReflectionException
     */
    public static function checkConstKey(string $key): bool
    {
        $constants = self::getConstValues();
        return isset($constants[$key]);
    }

    /**
     * @param mixed $value
     * @return bool
     * @throws ReflectionException
     */
    public static function checkConstValue($value): bool
    {
        $constants = self::getConstValues();
        return in_array($value, $constants, true);
    }

    /**
     * @return array<string,DocCommentObject>|DocCommentObject[]
     * @throws ReflectionException
     */
    public static function getConstDocCommentObjects(): array
    {
        $className = get_called_class();
        if (!isset(self::$docComArray[$className])) {
            $reflect = ClassHelper::reflectClass($className);
            $reflectConstArray = $reflect->getReflectionConstants();
            $docComArr = array();
            foreach ($reflectConstArray as $refConst) {
                $docComArr[$refConst->getName()] = DocCommentObject::parse($refConst->getDocComment());
            }

            self::$docComArray[$className] = $docComArr;
        }
        return self::$docComArray[$className];

    }

    /**
     * @param string $className
     * @return array
     * @throws ReflectionException
     */
    private static function getConstantsArray(string $className): array
    {
        if (!isset(self::$constArray[$className])) {
            $reflect = ClassHelper::reflectClass($className);
            self::$constArray[$className] = $reflect->getConstants();
        }
        return self::$constArray[$className];
    }

}