<?php


namespace Gek\Infrastructure\Tests\Events;


use Gek\Infrastructure\Events\EventArguments;
use Gek\Infrastructure\Events\EventHandler;
use Gek\Infrastructure\Exceptions\InvalidArgumentException;
use Gek\Infrastructure\Tests\Mocups\Events\DummyEventArguments;
use PHPUnit\Framework\TestCase;

/**
 * Class EventHandlerTest
 * @package Gek\Infrastructure\Tests\Events
 */
class EventHandlerTest extends TestCase
{

    public EventHandler $dummyEventHandler;

    public bool $checkInClass = false;
    public bool $checkInClass2 = false;

    public function setUp(): void
    {
        parent::setUp();
        $this->dummyEventHandler = new EventHandler();
        $this->checkInClass = false;
    }

    public function testStartState():void {
        $this->assertEquals(
            0,
            $this->dummyEventHandler->count()
        );
        $this->assertEquals(
            true,
            $this->dummyEventHandler->isEmpty()
        );
    }

    public function testAddListenerClassMethod():void {
        $this->dummyEventHandler->add([$this,'dummyEventListener'],true);
        $this->assertEquals(
            1,
            $this->dummyEventHandler->count()
        );
        $this->assertEquals(
            false,
            $this->dummyEventHandler->isEmpty()
        );
        // ikinci kere aynı fonksiyon ekleniyor
        $this->dummyEventHandler->add([$this,'dummyEventListener'],true);
        $this->assertEquals(
            1,
            $this->dummyEventHandler->count()
        );
        $this->assertEquals(
            false,
            $this->dummyEventHandler->isEmpty()
        );
    }

    public function testRemoveListenerClassMethod():void {
        $this->dummyEventHandler->remove([$this,'dummyEventListener']);
        $this->assertEquals(
            0,
            $this->dummyEventHandler->count()
        );
        $this->assertEquals(
            true,
            $this->dummyEventHandler->isEmpty()
        );

    }

    public function testEventFired():void {

        $check = false;
        $outEventArgs = null;
        $outSender = null;


        $eventListenerFn = function (object $sender,EventArguments $eventArguments) use(&$check,&$outEventArgs,&$outSender ){
            $check = true;
            $outEventArgs = $eventArguments;
            $outSender = $sender;
        };
        $this->dummyEventHandler->add($eventListenerFn,true);
        $this->dummyEventHandler->add([$this,'dummyEventListener'],true);
        $this->dummyEventHandler->add([$this,'dummyEventListener2'],true);

        $dummyEventArg = new DummyEventArguments();

        $this->dummyEventHandler->invoke($this, $dummyEventArg);
        $this->assertEquals(
            true,
            $check
        );
        $this->assertTrue($outSender === $this);
        $this->assertTrue($outEventArgs ===  $dummyEventArg);
        $this->assertEquals(
            true,
            $this->checkInClass
        );
        $this->assertEquals(
            true,
            $this->checkInClass2
        );
    }

    public function testClearListeners():void {
        $this->dummyEventHandler->add(function ($a,$b){});
        $this->dummyEventHandler->add(function ($a,$b){});

        $this->dummyEventHandler->clear();
        $this->assertEquals(
            0,
            $this->dummyEventHandler->count()
        );
        $this->assertEquals(
            true,
            $this->dummyEventHandler->isEmpty()
        );
    }

    public function testAddInvalidListener():void {
        $this->expectException(InvalidArgumentException::class);
        $this->dummyEventHandler->add(function (bool $a){},true);
    }

    /**
     * @param object $sender
     * @param EventArguments $eventArguments
     */
    public function dummyEventListener(object $sender, EventArguments $eventArguments):void {
        $this->checkInClass = true;
    }

    /**
     * @param object $sender
     * @param DummyEventArguments $eventArguments
     */
    public function dummyEventListener2(object $sender, DummyEventArguments $eventArguments):void {
        $this->checkInClass2 = true;
    }

}
