<?php


namespace Gek\Infrastructure\Tests;


use Gek\Infrastructure\Exceptions\NotImplementedException;
use Gek\Infrastructure\Exceptions\InvalidArgumentException;
use Gek\Infrastructure\Tests\Mocups\DummyConstClassType;
use PHPUnit\Framework\TestCase;

class ConstClassTypeTest extends TestCase
{

    public function testConstructValue():void {
        $dm = new DummyConstClassType(3);
        $this->assertEquals(
            3,
            $dm->getValue()
        );
        $this->assertEquals(
            'TEST3',
            $dm->__toString()
        );

        $dm = new DummyConstClassType(true);
        $this->assertEquals(
            true,
            $dm->getValue()
        );
        $this->assertEquals(
            'TEST1',
            $dm->__toString()
        );
        $dm = new DummyConstClassType('TWO');
        $this->assertEquals(
            'TWO',
            $dm->getValue()
        );
        $this->assertEquals(
            'TEST2',
            $dm->__toString()
        );
        $dm = new DummyConstClassType(4.2);
        $this->assertEquals(
            4.2,
            $dm->getValue()
        );
        $this->assertEquals(
            'TEST4',
            $dm->__toString()
        );
    }

    public function testConstructInvalidValue():void {
        $this->expectException(InvalidArgumentException::class);
        $this->expectExceptionMessage('Set edilmeye çalışılan değer ("30") Gek\Infrastructure\Tests\Mocups\DummyConstClassType tipinin değerleri / anahtarları arasında bulunamadı.');
        $dm = new DummyConstClassType(30);
    }

    public function testConstructStringKey():void {
        $dm = new DummyConstClassType('TEST3');
        $this->assertEquals(
            3,
            $dm->getValue()
        );
        $this->assertEquals(
            'TEST3',
            $dm->__toString()
        );

        $dm = new DummyConstClassType('TEST1');
        $this->assertEquals(
            true,
            $dm->getValue()
        );
        $this->assertEquals(
            'TEST1',
            $dm->__toString()
        );
        $dm = new DummyConstClassType('TEST2');
        $this->assertEquals(
            'TWO',
            $dm->getValue()
        );
        $this->assertEquals(
            'TEST2',
            $dm->__toString()
        );
        $dm = new DummyConstClassType('TEST4');
        $this->assertEquals(
            4.2,
            $dm->getValue()
        );
        $this->assertEquals(
            'TEST4',
            $dm->__toString()
        );
    }
    public function testConstructInvalidKey():void {
        $this->expectException(InvalidArgumentException::class);
        $this->expectExceptionMessage('Set edilmeye çalışılan değer ("TEST30") Gek\Infrastructure\Tests\Mocups\DummyConstClassType tipinin değerleri / anahtarları arasında bulunamadı.');
        $dm = new DummyConstClassType('TEST30');
    }

    public function testStaticFunc():void {
        $control = new DummyConstClassType('TEST1');
        $t1 = DummyConstClassType::TEST1();
        $this->assertEquals(
            $control,
            $t1
        );
        $this->assertEquals(
            DummyConstClassType::TEST1,
            $t1->getValue()
        );

        $this->assertEquals(
            'TEST1',
            $t1->__toString()
        );
    }

    public function testInvalidStaticFunc():void {
        $this->expectException(NotImplementedException::class);
        $t1 = DummyConstClassType::TEST33();
    }

    public function testToString():void {
        $t2 = DummyConstClassType::TEST2();
        $this->assertEquals(
            'TEST2',
            $t2 . ''
        );
        $this->assertEquals(
            'TEST2',
            strval($t2)
        );
        $this->assertEquals(
            'TEST2',
            $t2->__toString()
        );
    }

    public function testGetValue():void {
        $t4 = DummyConstClassType::TEST4();
        $this->assertEquals(
            4.2,
            $t4->getValue()
        );
        $this->assertEquals(
            4.200,
            $t4->getValue()
        );
        $this->assertTrue(is_float($t4->getValue()));
    }

    public function testSetValue():void {
        $t = DummyConstClassType::TEST3();
        $t->setValue('TWO');
        $this->assertEquals(
            'TWO',
            $t->getValue()
        );
        $this->assertEquals(
            'TEST2',
            $t.''
        );
    }

    public function testSetValueUseKey():void {
        $t = DummyConstClassType::TEST3();
        $t->setValue('TEST1');
        $this->assertEquals(
            true,
            $t->getValue()
        );
        $this->assertEquals(
            'TEST1',
            $t.''
        );

        $t->setValue('TEST4');
        $this->assertEquals(
            4.2,
            $t->getValue()
        );
        $this->assertEquals(
            'TEST4',
            $t.''
        );
    }
}