<?php


namespace Gek\Infrastructure\FlagExp;


/**
 * Class BitwiseXorExpression
 * @package Gek\Infrastructure\FlagExp
 */
class BitwiseXorExpression extends FlagExpression
{
    public ?FlagExpression $left;
    public ?FlagExpression $right;

    /**
     * BitwiseXorExpression constructor.
     * @param FlagExpression|null $left
     * @param FlagExpression|null $right
     */
    public function __construct(?FlagExpression $left = null, ?FlagExpression $right = null)
    {
        $this->left = $left;
        $this->right = $right;
    }

    /**
     * @return int
     */
    public function calculateValue(): int
    {
        return $this->left->calculateValue() ^ $this->right->calculateValue();
    }
}
