<?php


namespace Gek\Infrastructure\Tests;


use Gek\Infrastructure\Tests\Mocups\IntEnum;
use Gek\Infrastructure\Tests\Mocups\MixedEnum;
use PHPUnit\Framework\TestCase;

/**
 * Class EnumTest
 * @package Gek\Infrastructure\Tests
 */
class EnumTest extends TestCase
{

    public function testGetEnumValues()
    {
        $values = IntEnum::getEnumValues();
        $this->assertEquals([
            'TEST_ONE' => 1,
            'TEST_TWO' => 2,
            'TEST_THREE' => 3,
            'TEST_FOUR' => 4
        ], $values);

        $values = MixedEnum::getEnumValues();
        $this->assertEquals([
            'TEST_ONE' => true,
            'TEST_TWO' => 'TWO',
            'TEST_THREE' => 3,
            'TEST_FOUR' => 4.2
        ], $values);
    }

    public function testGetEnumValue()
    {
        $value = IntEnum::getEnumValue('TEST_ONE');
        $this->assertEquals(
            IntEnum::TEST_ONE,
            $value
        );
        $value = IntEnum::getEnumValue('INVALID_KEY');
        $this->assertEquals(
            null,
            $value
        );

        $value = MixedEnum::getEnumValue('TEST_ONE');
        $this->assertEquals(
            MixedEnum::TEST_ONE,
            $value
        );
        $this->assertTrue(is_bool($value));

        $value = MixedEnum::getEnumValue('TEST_TWO');
        $this->assertEquals(
            MixedEnum::TEST_TWO,
            $value
        );
        $this->assertTrue(is_string($value));

        $value = MixedEnum::getEnumValue('TEST_THREE');
        $this->assertEquals(
            MixedEnum::TEST_THREE,
            $value
        );
        $this->assertTrue(is_int($value));

        $value = MixedEnum::getEnumValue('TEST_FOUR');
        $this->assertEquals(
            MixedEnum::TEST_FOUR,
            $value
        );
        $this->assertTrue(is_float($value));

        $value = MixedEnum::getEnumValue('INVALID_KEY');
        $this->assertEquals(
            null,
            $value
        );
    }

    public function testCheckEnumKey()
    {
        $value = IntEnum::checkEnumKey('TEST_ONE');
        $this->assertEquals(
            true,
            $value
        );
        $value = IntEnum::checkEnumKey('INVALID_KEY');
        $this->assertEquals(
            false,
            $value
        );
    }

    public function testCheckEnumValue()
    {
        $value = IntEnum::checkEnumValue(1);
        $this->assertEquals(
            true,
            $value
        );
        $value = IntEnum::checkEnumValue(60);
        $this->assertEquals(
            false,
            $value
        );

        $value = MixedEnum::checkEnumValue('1');
        $this->assertEquals(
            false,
            $value
        );


        $this->assertEquals(
            true,
            MixedEnum::checkEnumValue(true)
        );

        $this->assertEquals(
            true,
            MixedEnum::checkEnumValue('TWO')
        );

        $this->assertEquals(
            false,
            MixedEnum::checkEnumValue('two')
        );

        $this->assertEquals(
            true,
            MixedEnum::checkEnumValue(4.2)
        );
        $this->assertEquals(
            true,
            MixedEnum::checkEnumValue(4.200)
        );
    }

    public function testGetEnumDocComentObjects(): void
    {

        $docComObjs = IntEnum::getEnumDocComentObjects();
        $this->assertEquals(
            'test bir',
            $docComObjs['TEST_ONE']->getKey('label')
        );

    }

}

