<?php


namespace Gek\Infrastructure;

use Gek\Infrastructure\Exceptions\InvalidArgumentException;
use Gek\Infrastructure\Exceptions\NotImplementedException;

/**
 * Class EnumType
 * @package Gek\Infrastructure
 */
abstract class EnumType extends Enum implements IToInt
{
    private int $value;

    /**
     * EnumType constructor.
     * @param int|string $value
     * @throws InvalidArgumentException
     * @throws \ReflectionException
     */
    public function __construct($value)
    {
        $this->setValue($value);
    }

    /**
     * @return int
     */
    public function getValue():int {
        return $this->value;
    }

    /**
     * @param int|string $val
     * @throws InvalidArgumentException
     * @throws \ReflectionException
     */
    public function setValue($val):void {
        if(is_int($val)){
            if(!self::checkEnumValue($val)){
                throw new InvalidArgumentException(
                    Str::format('Set edilmeye çalışılan değer ("{0}") Enum tipinin değerleri arasında bulunamadı.', $val),
                    0,
                    null,
                    '$val'
                );
            }
            $this->value = $val;
        }elseif (is_string($val)){
            if(!self::checkEnumKey($val)){
                throw new InvalidArgumentException(
                    Str::format('Set edilmeye çalışılan değer ("{0}") Enum tipinin değerleri arasında bulunamadı.', $val),
                    0,
                    null,
                    '$val'
                );
            }
            $this->value = self::getEnumValue($val);
        }else{
            throw new InvalidArgumentException(
                'Geçersiz parametre tipi. Parametre tipi int veya string olmalı.',
                0,
                null,
                '$val'
            );
        }
    }

    /**
     * @return string
     * @throws \ReflectionException
     */
    public function __toString()
    {
       $values = self::getEnumValues();
       foreach ($values as $key => $val){
           if($this->value == $val){
               return $key;
           }
       }
       return '';
    }

    /**
     * @return int
     */
    public function toInt():int{
        return $this->value;
    }

    /**
     * @param $name
     * @param $arguments
     * @return mixed
     * @throws NotImplementedException
     * @throws \ReflectionException
     */
    public static function __callStatic($name, $arguments)
    {
        if(self::checkEnumKey($name)){
            $class = get_called_class();
            return new $class($name);
        }
        throw new NotImplementedException();
    }



}
