<?php


namespace Gek\Infrastructure\Tests\Reflections;


use Gek\Infrastructure\Reflections\DocCommentObject;
use PHPUnit\Framework\TestCase;

/**
 * Class DocCommentObjectTest
 * @package Gek\Infrastructure\Tests\Reflections
 */
class DocCommentObjectTest extends TestCase
{

    public function testParseMethodNewInstance(): void
    {
        $docCom1 = DocCommentObject::parse(null);
        $docCom2 = DocCommentObject::parse(null);
        $this->assertFalse($docCom1 === $docCom2);
    }

    public function testNullDocComment(): void
    {
        $docCom = DocCommentObject::parse(null);
        $this->assertEquals(null, $docCom->getDocComment());
        $this->assertTrue(empty($docCom->getComments()));
        $this->assertTrue(empty($docCom->getKeys()));
    }

    public function testEmptyDocComment(): void
    {
        $docCom = DocCommentObject::parse('');
        $this->assertEquals('', $docCom->getDocComment());
        $this->assertTrue(empty($docCom->getComments()));
        $this->assertTrue(empty($docCom->getKeys()));
    }

    public function testWhiteSpacesDocComment(): void
    {
        $docCom = DocCommentObject::parse('     ');
        $this->assertEquals('     ', $docCom->getDocComment());
        $this->assertTrue(empty($docCom->getComments()));
        $this->assertTrue(empty($docCom->getKeys()));
    }

    public function testParseDocComments(): void
    {
        $testDocComStr = <<<DOCBLOCK
/**
 * This is a summary.
 * This is a multiline Description
 * that contains a code block.
 *
 *     See here: a CodeBlock
 * @var string|null
 * @required
 * @label sample
 */
DOCBLOCK;
        $docCom = DocCommentObject::parse($testDocComStr);
        $this->assertEquals($testDocComStr, $docCom->getDocComment());
        $this->assertEquals(4, count($docCom->getComments()));

        $this->assertEquals(
            'This is a summary.',
            $docCom->getComments()[0]
        );
        $this->assertEquals(
            'This is a multiline Description',
            $docCom->getComments()[1]
        );
        $this->assertEquals(
            'that contains a code block.',
            $docCom->getComments()[2]
        );
        $this->assertEquals(
            'See here: a CodeBlock',
            $docCom->getComments()[3]
        );

        $this->assertEquals(
            3,
            count($docCom->getKeys())
        );

        $this->assertEquals(
            'string|null',
            $docCom->getKey('var')
        );
        $this->assertEquals(
            'string|null',
            $docCom->getKey(' @var ')
        );
        $this->assertEquals(
            true,
            $docCom->getKey('required')
        );
        $this->assertEquals(
            'sample',
            $docCom->getKey(" \t @LaBEl  ")
        );
        $this->assertEquals(
            null,
            $docCom->getKey('invalid')
        );

        $this->assertEquals(
            [
                'var' => 'string|null',
                'required' => true,
                'label' => 'sample'
            ],
            $docCom->getKeys()
        );

        $testDocComStr2 = <<<DOCBLOCK
/**
 * This is a summary.
 * @var string|null
 * @required
 * @label sample
 * @key value
 */
DOCBLOCK;

        $docCom->setDocComment($testDocComStr2);

        $this->assertEquals(
            $testDocComStr2,
            $docCom->getDocComment()
        );
        $this->assertEquals(
            1,
            count($docCom->getComments())
        );
        $this->assertEquals(
            ['This is a summary.'],
            $docCom->getComments()
        );
        $this->assertEquals(
            4,
            count($docCom->getKeys())
        );
        $this->assertEquals(
            [
                'var' => 'string|null',
                'required' => true,
                'label' => 'sample',
                'key' => 'value'
            ],
            $docCom->getKeys()
        );

    }


}
