<?php


namespace Gek\Infrastructure\FlagExp;

/**
 * IntValueExpression sınıfı
 *
 * Int değer ifadesi
 *
 * @package Gek\Infrastructure\Enums
 */
class IntValueExpression extends FlagExpression
{

    /**
     * @var int Değer
     */
    private int $value;

    /**
     * IntValueExpression yapıcı metod.
     * @param int $value değer.
     */
    public function __construct(int $value)
    {
        $this->value = $value;
    }

    /**
     * @inheritDoc
     */
    public function calculateValue(): int
    {
        return $this->value;
    }
}
