<?php


namespace Gek\Infrastructure\FlagExp;


/**
 * BitwiseAndExpression sınıfı
 *
 * Bitsel "Ve" İfadesi
 *
 * @package Gek\Infrastructure\Enums
 */
class BitwiseAndExpression extends FlagExpression
{
    /**
     * @var FlagExpression|null Sol ifade
     */
    public ?FlagExpression $left;

    /**
     * @var FlagExpression|null Sağ ifade
     */
    public ?FlagExpression $right;

    /**
     * BitwiseAndExpression yapıcı metod.
     * @param FlagExpression|null $left Sol ifade
     * @param FlagExpression|null $right Sağ ifade
     */
    public function __construct(?FlagExpression $left = null, ?FlagExpression $right = null)
    {
        $this->left = $left;
        $this->right = $right;
    }

    /**
     * @inheritDoc
     */
    public function calculateValue(): int
    {
        return $this->left->calculateValue() & $this->right->calculateValue();
    }
}
