<?php //common
use Gek\Infrastructure\Str;

include_once __DIR__ . "/../../../../vendor/autoload.php";

?>
# \Gek\Infrastructure\Str::convertEncoding() kullanımı

**Metnin kodlamasını değiştirir.**

## Basit Kullanım

**örnek 1:**
<?php

$file = __DIR__. DIRECTORY_SEPARATOR ."unicode.txt";
$dt = fopen($file, "rb");
fread($dt, 2);
$utf16 = fread($dt, filesize($file));
fclose($dt);

$utf8 = 'Atakan Çalışkan';

var_dump($utf8 == $utf16); // bool(false)

var_dump($utf8); // string(18) "Atakan Çalışkan"
var_dump($utf16); // string(30) "\000A\000t\000a\000k\000a\000n\000 \000\000a\000l╔1╔_\000k\000a\000n"
var_dump(Str::convertEncoding($utf16,'UTF-8','UNICODE')); //string(18) "Atakan Çalışkan"

var_dump($utf8 == Str::convertEncoding($utf16,'UTF-8','UNICODE')); // bool(true)

var_dump($utf8 == Str::convertEncoding($utf16,null,'UNICODE')); // bool(true)

var_dump($utf8 == Str::convertEncoding($utf16,null,null)); // bool(true)

var_dump( $utf16 == Str::convertEncoding($utf8,'UNICODE','UTF-8')); // bool(true)


