<?php //common
use Gek\Infrastructure\Str;

include_once __DIR__ . "/../../../../vendor/autoload.php";

?>
# \Gek\Infrastructure\Str::contains() kullanımı

**Bir metnin içinde varilen metin olup olmadığını kontrol eder.**

## Basit Kullanım

**örnek 1:**
<?php
$str = "The quick Brown fox jumps over the lazy dog.";

$sonuc = Str::contains($str,"Brown");
var_dump($sonuc); //bool(true)

$sonuc = Str::contains($str,"brown");
var_dump($sonuc); //bool(false)

$sonuc = Str::contains($str,"");
var_dump($sonuc); //bool(false)

$sonuc = Str::contains($str,null);
var_dump($sonuc); //bool(false)

?>

## Büyük/Küçük harf ayrımı olmadan

**örnek 1:**
<?php
$str = "The quick Brown fox jumps over the lazy dog.";

$sonuc = Str::contains($str,"Brown",/* ignoreCaseSensitive */true);
var_dump($sonuc); //bool(true)

$sonuc = Str::contains($str,"brown",/* ignoreCaseSensitive */true);
var_dump($sonuc); //bool(true)
?>

**örnek 2:** Dile özgü küçük/büyük harfler
<?php
$str = "Evlerin ışıkları yanıyor.";

$sonuc = Str::contains($str,"ışık",/* ignoreCaseSensitive */true);
var_dump($sonuc); //bool(true)

$sonuc = Str::contains($str,"IŞIK",/* ignoreCaseSensitive */true);
var_dump($sonuc); //bool(false)

$sonuc = Str::contains($str,"IŞIK",/* ignoreCaseSensitive */true,/* encoding */null,/* langugae */ "tr");
var_dump($sonuc); //bool(true)


$str = "Ha bu ışıklı dünya oldu bize karanlık.";

// Türkçe dil belirtmeden
$sonuc = Str::contains($str,"ışıklı",true);
var_dump($sonuc); //bool(true)

$sonuc = Str::contains($str,"IŞIKLI",true);
var_dump($sonuc); //bool(false)

// Türkçe dil belirterek
$sonuc = Str::contains($str,"ışıklı",true,null,'tr');
var_dump($sonuc); //bool(true)

$sonuc = Str::contains($str,"IŞIKLI",true,null,'tr');
var_dump($sonuc); //bool(true)


?>
