<?php //common
use Gek\Infrastructure\Str;

include_once __DIR__ . "/../../../../vendor/autoload.php";

?>
# \Gek\Infrastructure\Str::containsCount() kullanımı

**Bir metnin içinde varilen metnin kaç kere geçtiğini bulur**

## Basit Kullanım

**örnek 1:**
<?php
$str = "The quick Brown fox jumps over the lazy dog.O0";

$sonuc = Str::containsCount($str,"The");
var_dump($sonuc); // int(1)

$sonuc = Str::containsCount($str,"süleyman");
var_dump($sonuc); // int(0)

$sonuc = Str::containsCount($str,"the");
var_dump($sonuc); // int(1)

$sonuc = Str::containsCount($str,"o");
var_dump($sonuc); // int(4)

$sonuc = Str::containsCount($str,"O");
var_dump($sonuc); // int(1)

$sonuc = Str::containsCount($str,"");
var_dump($sonuc); // int(0)

$sonuc = Str::containsCount($str,null);
var_dump($sonuc); // int(0)

$sonuc = Str::containsCount($str,0);
var_dump($sonuc); // int(1)

?>

## Büyük/Küçük harf ayrımı olmadan

**örnek 1:**
<?php
$str = "The quick Brown fox jumps over the lazy dog.O";

$sonuc = Str::containsCount($str,"The",true);
var_dump($sonuc); // int(2)

$sonuc = Str::containsCount($str,"the",true);
var_dump($sonuc); // int(2)

$sonuc = Str::containsCount($str,"o",true);
var_dump($sonuc); // int(5)

$sonuc = Str::containsCount($str,"O",true);
var_dump($sonuc); // int(5)

$str = "Işıksız ışıldak mı olur? Işıldak dediğin ışık saçar.";

// Türkçe dil belirtmeden
$sonuc = Str::containsCount($str,"ışı",true);
var_dump($sonuc); // int(2)
$sonuc = Str::containsCount($str,"Işı",true);
var_dump($sonuc); // int(2)

// Türkçe dil belirterek
$sonuc = Str::containsCount($str,"ışı",true,null,"tr");
var_dump($sonuc); // int(4)
$sonuc = Str::containsCount($str,"Işı",true,null,"tr");
var_dump($sonuc); // int(4)

?>

