<?php //common
use Gek\Infrastructure\ConstClassType;

include_once __DIR__ . "/../../../../vendor/autoload.php";

?>
# \Gek\Infrastructure\ConstClassType::__callStatic() kullanımı

**sabit adından yeni bir nesne örneği oluşturur.**

## Basit Kullanım

**örnek 1:**
<?php
/**
 * Class UpdateFrequency
 * @package Seo\Sitemap
 * @method static self ALWAYS()
 * @method static self HOURLY()
 * @method static self DAILY()
 * @method static self WEEKLY()
 * @method static self MONTHLY()
 * @method static self YEARLY()
 * @method static self NEVER()
 */
class UpdateFrequency extends ConstClassType
{

    /**
     * @label Her Zaman
     */
    public const ALWAYS = "always";

    /**
     * @label Saatlik
     */
    public const HOURLY = "hourly";

    /**
     * @label Günlük
     */
    public const DAILY = "daily";

    /**
     * @label Haftalık
     */
    public const WEEKLY = "weekly";

    /**
     * @label Aylık
     */
    public const MONTHLY = "monthly";

    /**
     * @label Yıllık
     */
    public const YEARLY = "yearly";

    /**
     * @label Statik
     */
    public const NEVER = "never";

}


$hourly = UpdateFrequency::__callStatic("HOURLY",null);

var_dump($hourly);
/*
class UpdateFrequency#3 (1) {
  private $value =>
  string(6) "hourly"
}

 */

// ya da

$hourly = UpdateFrequency::HOURLY();

var_dump($hourly);
/*
class UpdateFrequency#3 (1) {
  private $value =>
  string(6) "hourly"
}

 */