# \Gek\Infrastructure\ConstClassType::setValue() kullanımı

**Nesne değerini set eder**

## Basit Kullanım

**örnek 1:**
```php
use Gek\Infrastructure\ConstClassType;

include_once __DIR__ . "/../../../../vendor/autoload.php";

/**
 * Class UpdateFrequency
 * @package Seo\Sitemap
 * @method static self ALWAYS()
 * @method static self HOURLY()
 * @method static self DAILY()
 * @method static self WEEKLY()
 * @method static self MONTHLY()
 * @method static self YEARLY()
 * @method static self NEVER()
 */
class UpdateFrequency extends ConstClassType
{

    /**
     * @label Her Zaman
     */
    public const ALWAYS = "always";

    /**
     * @label Saatlik
     */
    public const HOURLY = "hourly";

    /**
     * @label Günlük
     */
    public const DAILY = "daily";

    /**
     * @label Haftalık
     */
    public const WEEKLY = "weekly";

    /**
     * @label Aylık
     */
    public const MONTHLY = "monthly";

    /**
     * @label Yıllık
     */
    public const YEARLY = "yearly";

    /**
     * @label Statik
     */
    public const NEVER = "never";

}

$updateFreq = UpdateFrequency::ALWAYS();

var_dump($updateFreq->getValue()); //string(6) "always"

// key ile kullanım
$updateFreq->setValue("WEEKLY");

var_dump($updateFreq->getValue()); //string(6) "weekly"

// value ile kullanım
$updateFreq->setValue("yearly");

var_dump($updateFreq->getValue()); //string(6) "yearly"

// olmayan key/value

$updateFreq->setValue("OlmayanKeyYadaValue"); // Hata oluşur
/*
Fatal error: Uncaught Gek\Infrastructure\Exceptions\InvalidArgumentException: Set edilmeye çalışılan değer ("OlmayanKeyYadaValue") U
pdateFrequency tipinin değerleri / anahtarları arasında bulunamadı.
 */

```