# \Gek\Infrastructure\ConstClassType::__construct() kullanımı

**ConstClassType yapıcı method**
.
## Basit Kullanım

**örnek 1:**
```php
use Gek\Infrastructure\ConstClassType;

include_once __DIR__ . "/../../../../vendor/autoload.php";

/**
 * Class UpdateFrequency
 * @package Seo\Sitemap
 * @method static self ALWAYS()
 * @method static self HOURLY()
 * @method static self DAILY()
 * @method static self WEEKLY()
 * @method static self MONTHLY()
 * @method static self YEARLY()
 * @method static self NEVER()
 */
class UpdateFrequency extends ConstClassType
{

    /**
     * @label Her Zaman
     */
    public const ALWAYS = "always";

    /**
     * @label Saatlik
     */
    public const HOURLY = "hourly";

    /**
     * @label Günlük
     */
    public const DAILY = "daily";

    /**
     * @label Haftalık
     */
    public const WEEKLY = "weekly";

    /**
     * @label Aylık
     */
    public const MONTHLY = "monthly";

    /**
     * @label Yıllık
     */
    public const YEARLY = "yearly";

    /**
     * @label Statik
     */
    public const NEVER = "never";

}

// kodlar...

// Key kullanımı
$updateFreq1 = new UpdateFrequency("NEVER");

var_dump($updateFreq1);
/*
class UpdateFrequency#3 (1) {
  private $value =>
  string(5) "never"
}
*/

// value kullanımı

$updateFreq2 = new UpdateFrequency('monthly');

var_dump($updateFreq2);
/*
class UpdateFrequency#2 (1) {
  private $value =>
  string(7) "monthly"
}
*/

$olmayan = new UpdateFrequency("Olmayan"); // Hata oluşur
// Fatal error: Uncaught Gek\Infrastructure\Exceptions\InvalidArgumentException: Set edilmeye çalışılan değer ("Olmayan") UpdateFrequen
//cy tipinin değerleri / anahtarları arasında bulunamadı.
```