# \Gek\Infrastructure\ClassHelper::reflectClass() kullanımı

**Verilen sınıf isminden sınıfın yansımasını (reflection) döndürür.**

## Basit Kullanım

**örnek 1:**
```php
use Gek\Infrastructure\ClassHelper;

include_once __DIR__ . "/../../../../vendor/autoload.php";

class SampleClass{
    public string $propA;
    public string $propB;

    public function metodA(){

    }

    public function metodB(){

    }
}

$reflected = ClassHelper::reflectClass(SampleClass::class);

var_dump($reflected->getMethods());
/*
array(2) {
  [0] =>
  class ReflectionMethod#2 (2) {
    public $name =>
    string(6) "metodA"
    public $class =>
    string(11) "SampleClass"
  }
  [1] =>
  class ReflectionMethod#4 (2) {
    public $name =>
    string(6) "metodB"
    public $class =>
    string(11) "SampleClass"
  }
}

 */



```