# \Gek\Infrastructure\ClassHelper::getMetaObject() kullanımı

**Verilen nesnenin özelliklerini sitring olarak tutan bir nesne döndürür.**

## Basit Kullanım

**örnek 1:** Standart nesne kullanımı.
```php

use Gek\Infrastructure\ClassHelper;

include_once __DIR__ . "/../../../../vendor/autoload.php";

$stdObject = (object)[
    'prop1' => 10,
    'deneme' => "aaaaaaa",
];

$metaObj = ClassHelper::getMetaObject($stdObject);

var_dump($metaObj);
/*
 class stdClass#6 (2) {
  public $prop1 =>
  string(5) "prop1"
  public $deneme =>
  string(6) "deneme"
}
 */
```

**örnek 2:** Kullanıcı tanımlı nesne kullanımı.
```php

use Gek\Infrastructure\ClassHelper;

include_once __DIR__ . "/../../../../vendor/autoload.php";

class SampleClass{
    public string $prop1 = "asdaasdas";
    public int $deneme = 15;
}

$sampleObj = new SampleClass();

$metaObj = ClassHelper::getMetaObject($sampleObj);

var_dump($metaObj);
/*
 class stdClass#8 (2) {
  public $prop1 =>
  string(5) "prop1"
  public $deneme =>
  string(6) "deneme"
}
 */


```