# \Gek\Infrastructure\ClassHelper::getDocCommentObject() kullanımı

**Verilen Reflector nesnesinin docComment ini DocCommentObject olarak döndürür.**

## Basit Kullanım

**örnek 1:**
```php
use Gek\Infrastructure\ClassHelper;

include_once __DIR__ . "/../../../../vendor/autoload.php";

/**
 * Class Test
 *
 * @since 1.5
 * @api
 * @package Test\Sample\Pagkage
 */
class Test{

    /**
     * @var string
     * @since 1.2
     */
    public string $prop = "test";

    /**
     * Fonksiyon Kısa açıklama
     *
     * Uzun açıklama sad sdfsdf dfggf dfgdfgdf dfgdfg
     *
     * @param int $param1
     * @return string
     */
    public function Deneme(int $param1):string {
        return "sayı: " . $param1;
    }

}

$reflected = ClassHelper::reflectClass(Test::class);

$docCom = ClassHelper::getDocCommentObject($reflected);

var_dump($docCom->getSummary());
/*
array(1) {
  [0] =>
  string(10) "Class Test"
}
*/
var_dump($docCom->getComments());
/*
array(0) {
}
*/
var_dump($docCom->getKeys());
/*
array(3) {
  'since' =>
  string(3) "1.5"
  'api' =>
  bool(true)
  'package' =>
  string(19) "Test\Sample\Pagkage"
}
*/
var_dump($docCom->getKey('since')); //string(3) "1.5"
// olmayan
var_dump($docCom->getKey('mahmut')); // NULL


```