---
title: \Gek\Infrastructure\Math\Decimal
footer: false
---

# Decimal

Decimal Sınıfı

Decimal türünü simule eder

örnek: [Decimal](../../../../examples/Gek/Infrastructure/Math/Decimal_class/index.md)


* Full name (Tam Adı): `\Gek\Infrastructure\Math\Decimal`
* Bu sınıf şu arayüzleri (interface) uygular:  \Gek\Infrastructure\IComparable, \Gek\Infrastructure\IToFloat, \Gek\Infrastructure\IEquatable, \Serializable, \JsonSerializable

**Kullanım:** [örnek](../../../../examples/Gek/Infrastructure/Math/Decimal_class/index.md)

**Ayrıca bakınız:**

* https://www.php.net/manual/en/book.bc.php - BCMath php eklentisi



## Methods (Yöntemler)

### __construct

Decimal yapıcı metod.

```php
public Decimal::__construct(float|int|string $value = 0.0, int $scale = 6, string $decPoint = &#039;.&#039;, string $thousandsSep = &quot;,&quot;): mixed
```








**Parameters (parametreler,argümanlar):**

| Parameter | Type | Description |
|-----------|------|-------------|
| `value` | **float|int|string** | değer |
| `scale` | **int** | ondalık basamak hassasiyeti |
| `decPoint` | **string** | ondalık ayracı |
| `thousandsSep` | **string** | binlik ayracı |


**Return Value (Dönüş değeri):**


mixed



**Kullanım:** [örnek](../../../../examples/Gek/Infrastructure/Math/Decimal_class/__construct_method.md)


---
### getScale

ondalık basamak hassasiyetini verir.

```php
public Decimal::getScale(): int
```









**Return Value (Dönüş değeri):**


int



**Kullanım:** [örnek](../../../../examples/Gek/Infrastructure/Math/Decimal_class/getScale_method.md)


---
### getDecPoint

ondalık ayracını verir

```php
public Decimal::getDecPoint(): string
```









**Return Value (Dönüş değeri):**


string



**Kullanım:** [örnek](../../../../examples/Gek/Infrastructure/Math/Decimal_class/getDecPoint_method.md)


---
### getThousandsSep

Binlik ayracını verir

```php
public Decimal::getThousandsSep(): string
```









**Return Value (Dönüş değeri):**


string



**Kullanım:** [örnek](../../../../examples/Gek/Infrastructure/Math/Decimal_class/getThousandsSep_method.md)


---
### getValue

değeri verir

```php
public Decimal::getValue(): string
```









**Return Value (Dönüş değeri):**


string



**Kullanım:** [örnek](../../../../examples/Gek/Infrastructure/Math/Decimal_class/getValue_method.md)


---
### numberToString

Float değeri stringe çevirir.

```php
protected Decimal::numberToString(float $number): string
```








**Parameters (parametreler,argümanlar):**

| Parameter | Type | Description |
|-----------|------|-------------|
| `number` | **float** |  |


**Return Value (Dönüş değeri):**


string



**Kullanım:** [örnek](../../../../examples/Gek/Infrastructure/Math/Decimal_class/numberToString_method.md)


---
### getOtherValue

İşlem için verilen diğer değeri işlem için hazırlar

```php
protected Decimal::getOtherValue(\Gek\Infrastructure\Math\Decimal|string|float|int $other): string
```








**Parameters (parametreler,argümanlar):**

| Parameter | Type | Description |
|-----------|------|-------------|
| `other` | **\Gek\Infrastructure\Math\Decimal|string|float|int** | değer |


**Return Value (Dönüş değeri):**

düxeltilmiş değer
string



**Kullanım:** [örnek](../../../../examples/Gek/Infrastructure/Math/Decimal_class/getOtherValue_method.md)


---
### compareTo

Verilen değerle mevcut değeri karşılaştırır

```php
public Decimal::compareTo(mixed $other): int
```








**Parameters (parametreler,argümanlar):**

| Parameter | Type | Description |
|-----------|------|-------------|
| `other` | **mixed** | diğer değer |


**Return Value (Dönüş değeri):**


int



**Kullanım:** [örnek](../../../../examples/Gek/Infrastructure/Math/Decimal_class/compareTo_method.md)

**Ayrıca bakınız:**

* \Gek\Infrastructure\IComparable - IComparable arayüzü


---
### toFloat

Mevcut değeri float türünde verir.

```php
public Decimal::toFloat(): float
```









**Return Value (Dönüş değeri):**


float



**Kullanım:** [örnek](../../../../examples/Gek/Infrastructure/Math/Decimal_class/toFloat_method.md)

**Ayrıca bakınız:**

* \Gek\Infrastructure\IToFloat - IToFloat Arayüzü


---
### equals

Verilen değer ile eşitlik kontrolu yapar.

```php
public Decimal::equals(float|int|string|\Gek\Infrastructure\Math\Decimal $other): bool
```








**Parameters (parametreler,argümanlar):**

| Parameter | Type | Description |
|-----------|------|-------------|
| `other` | **float|int|string|\Gek\Infrastructure\Math\Decimal** | diğer değer |


**Return Value (Dönüş değeri):**

eşitse true değilse false
bool



**Kullanım:** [örnek](../../../../examples/Gek/Infrastructure/Math/Decimal_class/equals_method.md)

**Ayrıca bakınız:**

* \Gek\Infrastructure\IEquatable - IEquatable Arayüzü


---
### serialize

nesnenin serileştirilmiş halini verir.

```php
public Decimal::serialize(): string
```









**Return Value (Dönüş değeri):**

serileştirilmiş veri
string



**Kullanım:** [örnek](../../../../examples/Gek/Infrastructure/Math/Decimal_class/serialize_method.md)

**Ayrıca bakınız:**

* https://www.php.net/manual/en/language.oop5.serialization.php - Php serileştirme.* https://www.php.net/manual/en/class.serializable.php - Serializable arayüzü


---
### unserialize

serileştirilmiş veriden nesneyi doldurur.

```php
public Decimal::unserialize(string $serialized): mixed
```

.






**Parameters (parametreler,argümanlar):**

| Parameter | Type | Description |
|-----------|------|-------------|
| `serialized` | **string** | serileştirilmiş veri. |


**Return Value (Dönüş değeri):**


mixed



**Kullanım:** [örnek](../../../../examples/Gek/Infrastructure/Math/Decimal_class/unserialize_method.md)

**Ayrıca bakınız:**

* https://www.php.net/manual/en/language.oop5.serialization.php - Php serileştirme.* https://www.php.net/manual/en/class.serializable.php - Serializable arayüzü


---
### jsonSerialize

değeri json için serileştirir.

```php
public Decimal::jsonSerialize(): mixed|string
```









**Return Value (Dönüş değeri):**


mixed|string



**Kullanım:** [örnek](../../../../examples/Gek/Infrastructure/Math/Decimal_class/jsonSerialize_method.md)

**Ayrıca bakınız:**

* https://www.php.net/manual/en/class.jsonserializable.php - JsonSerializable arayüzü.


---
### isGreaterThan

Değerin verilen değerden büyük olup olmadığını kontrol eder.

```php
public Decimal::isGreaterThan(\Gek\Infrastructure\Math\Decimal|string|float|int $other): bool
```








**Parameters (parametreler,argümanlar):**

| Parameter | Type | Description |
|-----------|------|-------------|
| `other` | **\Gek\Infrastructure\Math\Decimal|string|float|int** | Diğer değer. |


**Return Value (Dönüş değeri):**

Büyükse true aksi halde false
bool



**Kullanım:** [örnek](../../../../examples/Gek/Infrastructure/Math/Decimal_class/isGreaterThan_method.md)


---
### isGreaterOrEqualThan

Değerin verilen değerden büyük veya eşit olup olmadığını kontrol eder.

```php
public Decimal::isGreaterOrEqualThan(\Gek\Infrastructure\Math\Decimal|string|float|int $other): bool
```








**Parameters (parametreler,argümanlar):**

| Parameter | Type | Description |
|-----------|------|-------------|
| `other` | **\Gek\Infrastructure\Math\Decimal|string|float|int** | Diğer değer |


**Return Value (Dönüş değeri):**

Büyük veya eşitse true değilse false
bool



**Kullanım:** [örnek](../../../../examples/Gek/Infrastructure/Math/Decimal_class/isGreaterOrEqualThan_method.md)


---
### isLessThan

Değerin verilen değerden küçük olup olmadığını kontrol eder.

```php
public Decimal::isLessThan(\Gek\Infrastructure\Math\Decimal|string|float|int $other): bool
```








**Parameters (parametreler,argümanlar):**

| Parameter | Type | Description |
|-----------|------|-------------|
| `other` | **\Gek\Infrastructure\Math\Decimal|string|float|int** | Diğer deüer. |


**Return Value (Dönüş değeri):**

Küçükse true aksi halde false
bool



**Kullanım:** [örnek](../../../../examples/Gek/Infrastructure/Math/Decimal_class/isLessThan_method.md)


---
### isLessOrEqualThan

Değerin verilen değerden küçük veya eşit olup olmadığını kontrol eder.

```php
public Decimal::isLessOrEqualThan(\Gek\Infrastructure\Math\Decimal|string|float|int $other): bool
```








**Parameters (parametreler,argümanlar):**

| Parameter | Type | Description |
|-----------|------|-------------|
| `other` | **\Gek\Infrastructure\Math\Decimal|string|float|int** | Diğer değer. |


**Return Value (Dönüş değeri):**

Küçük veya eşitse true aksi halde false
bool



**Kullanım:** [örnek](../../../../examples/Gek/Infrastructure/Math/Decimal_class/isLessOrEqualThan_method.md)


---
### add

Toplama işlemi

```php
public Decimal::add(float|int|string|\Gek\Infrastructure\Math\Decimal $other): \Gek\Infrastructure\Math\Decimal
```

Verilen değeri mevcut değer ile toplar.






**Parameters (parametreler,argümanlar):**

| Parameter | Type | Description |
|-----------|------|-------------|
| `other` | **float|int|string|\Gek\Infrastructure\Math\Decimal** | Diğer değer |


**Return Value (Dönüş değeri):**

Toplama sonucu
\Gek\Infrastructure\Math\Decimal



**Kullanım:** [örnek](../../../../examples/Gek/Infrastructure/Math/Decimal_class/add_method.md)


---
### __toString

Değeri string olarak verir.

```php
public Decimal::__toString(): string
```









**Return Value (Dönüş değeri):**

Değerin string hali
string



**Kullanım:** [örnek](../../../../examples/Gek/Infrastructure/Math/Decimal_class/__toString_method.md)

**Ayrıca bakınız:**

* https://www.php.net/manual/en/language.oop5.magic.php#object.tostring - Php __toString sihirli yöntemi


---
### toHumanizeString

Değeri insanların okuması için stringe çevirir.

```php
public Decimal::toHumanizeString(int|null $decimals = null): string
```








**Parameters (parametreler,argümanlar):**

| Parameter | Type | Description |
|-----------|------|-------------|
| `decimals` | **int|null** | Ondalık basamak sayısı |


**Return Value (Dönüş değeri):**

Değerin string hali
string



**Kullanım:** [örnek](../../../../examples/Gek/Infrastructure/Math/Decimal_class/toHumanizeString_method.md)


---
### compare

Verilen değeri mevcut değer ile karşılaştırır

```php
public Decimal::compare(float|int|string|\Gek\Infrastructure\Math\Decimal $other): int
```








**Parameters (parametreler,argümanlar):**

| Parameter | Type | Description |
|-----------|------|-------------|
| `other` | **float|int|string|\Gek\Infrastructure\Math\Decimal** | Diğer değer |


**Return Value (Dönüş değeri):**

Karşılaştırma sonucu
int



**Kullanım:** [örnek](../../../../examples/Gek/Infrastructure/Math/Decimal_class/compare_method.md)

**Ayrıca bakınız:**

* https://www.php.net/manual/en/function.bccomp.php - bccomp fonksiyonu


---
### div

Bölme işlemi

```php
public Decimal::div(float|int|string|\Gek\Infrastructure\Math\Decimal $other): \Gek\Infrastructure\Math\Decimal
```

Mevcut değeri verilen değer e böler.






**Parameters (parametreler,argümanlar):**

| Parameter | Type | Description |
|-----------|------|-------------|
| `other` | **float|int|string|\Gek\Infrastructure\Math\Decimal** | Bölen değer. |


**Return Value (Dönüş değeri):**

Sonuç
\Gek\Infrastructure\Math\Decimal



**Kullanım:** [örnek](../../../../examples/Gek/Infrastructure/Math/Decimal_class/div_method.md)

**Ayrıca bakınız:**

* https://www.php.net/manual/en/function.bcdiv.php - bcdiv php metodu


---
### mod

Bölme işleminden kalanı bulur

```php
public Decimal::mod(float|int|string|\Gek\Infrastructure\Math\Decimal $other): \Gek\Infrastructure\Math\Decimal
```








**Parameters (parametreler,argümanlar):**

| Parameter | Type | Description |
|-----------|------|-------------|
| `other` | **float|int|string|\Gek\Infrastructure\Math\Decimal** | Bölen değer. |


**Return Value (Dönüş değeri):**

Kalan
\Gek\Infrastructure\Math\Decimal



**Kullanım:** [örnek](../../../../examples/Gek/Infrastructure/Math/Decimal_class/mod_method.md)

**Ayrıca bakınız:**

* https://www.php.net/manual/en/function.bcmod.php - bcmod php fonksiyonu


---
### mul

Çarpma işlemi

```php
public Decimal::mul(float|int|string|\Gek\Infrastructure\Math\Decimal $other): \Gek\Infrastructure\Math\Decimal
```

Mevcut değeri verilen değer ile çarpar.






**Parameters (parametreler,argümanlar):**

| Parameter | Type | Description |
|-----------|------|-------------|
| `other` | **float|int|string|\Gek\Infrastructure\Math\Decimal** | Çarpan değer |


**Return Value (Dönüş değeri):**

İşlem sonucu
\Gek\Infrastructure\Math\Decimal



**Kullanım:** [örnek](../../../../examples/Gek/Infrastructure/Math/Decimal_class/mul_method.md)

**Ayrıca bakınız:**

* https://www.php.net/manual/en/function.bcmul.php - bcmul php fonksiyonu


---
### pow

Üs alma işlemi yapar

```php
public Decimal::pow(int $exponent): \Gek\Infrastructure\Math\Decimal
```








**Parameters (parametreler,argümanlar):**

| Parameter | Type | Description |
|-----------|------|-------------|
| `exponent` | **int** | Üs değeri |


**Return Value (Dönüş değeri):**

İşlem sonucu
\Gek\Infrastructure\Math\Decimal



**Kullanım:** [örnek](../../../../examples/Gek/Infrastructure/Math/Decimal_class/pow_method.md)

**Ayrıca bakınız:**

* https://www.php.net/manual/en/function.bcpow.php - bcpow php fonksiyonu


---
### sub

Çıkartma işlemi yapar.

```php
public Decimal::sub(float|int|string|\Gek\Infrastructure\Math\Decimal $other): \Gek\Infrastructure\Math\Decimal
```

Mevcut değerden verilen değeri çıkartır.






**Parameters (parametreler,argümanlar):**

| Parameter | Type | Description |
|-----------|------|-------------|
| `other` | **float|int|string|\Gek\Infrastructure\Math\Decimal** | Çıkarılacak değer. |


**Return Value (Dönüş değeri):**

İşlem sonucu.
\Gek\Infrastructure\Math\Decimal



**Kullanım:** [örnek](../../../../examples/Gek/Infrastructure/Math/Decimal_class/sub_method.md)

**Ayrıca bakınız:**

* https://www.php.net/manual/en/function.bcsub.php - bcsub php fonksiyonu


---
### sqrt

Değerin karekökünü döndürür

```php
public Decimal::sqrt(): \Gek\Infrastructure\Math\Decimal
```









**Return Value (Dönüş değeri):**

Karakök
\Gek\Infrastructure\Math\Decimal



**Kullanım:** [örnek](../../../../examples/Gek/Infrastructure/Math/Decimal_class/sqrt_method.md)

**Ayrıca bakınız:**

* https://www.php.net/manual/en/function.bcsqrt.php - bcsqrt php işlevi


---
### round

Değerin yuvarlanmış halini verir.

```php
public Decimal::round(int $scale): false|float
```








**Parameters (parametreler,argümanlar):**

| Parameter | Type | Description |
|-----------|------|-------------|
| `scale` | **int** | Ondalık basamak hassasiyeti |


**Return Value (Dönüş değeri):**

yuvarlanmış değer
false|float



**Kullanım:** [örnek](../../../../examples/Gek/Infrastructure/Math/Decimal_class/round_method.md)

**Ayrıca bakınız:**

* https://www.php.net/manual/en/function.round.php - round php fonksiyonu


---
### floor

Değeri aşağı yuvarlar.

```php
public Decimal::floor(): false|float
```









**Return Value (Dönüş değeri):**

Yuvarlanmış değer
false|float



**Kullanım:** [örnek](../../../../examples/Gek/Infrastructure/Math/Decimal_class/floor_method.md)

**Ayrıca bakınız:**

* https://www.php.net/manual/en/function.floor.php - floor php fonksiyonu


---
### ceil

Değeri yukarı yuvarlar.

```php
public Decimal::ceil(): false|float
```









**Return Value (Dönüş değeri):**

Yuvarlanmış değer
false|float



**Kullanım:** [örnek](../../../../examples/Gek/Infrastructure/Math/Decimal_class/ceil_method.md)

**Ayrıca bakınız:**

* https://www.php.net/manual/en/function.ceil.php - ceil php fonksiyon


---
### wrap

Verilen değeri Decimal türünde verir.

```php
public static Decimal::wrap(self|float|int|string $val, int|null $scale = null): static
```



* Bu yöntem **statiktir**.




**Parameters (parametreler,argümanlar):**

| Parameter | Type | Description |
|-----------|------|-------------|
| `val` | **self|float|int|string** | Değer |
| `scale` | **int|null** | Ondalık basamak hassasiyetş |


**Return Value (Dönüş değeri):**

Decimal değer
static



**Kullanım:** [örnek](../../../../examples/Gek/Infrastructure/Math/Decimal_class/wrap_method.md)

**Ayrıca bakınız:**

* \Gek\Infrastructure\Math\Decimal::__construct - Decimal yapıcı method


---
### expF

Verilen ifadeyi işler ve sonucu verir.

```php
public static Decimal::expF(string $exp, int|null $scale = null): float
```



* Bu yöntem **statiktir**.




**Parameters (parametreler,argümanlar):**

| Parameter | Type | Description |
|-----------|------|-------------|
| `exp` | **string** | ifade |
| `scale` | **int|null** | ondalık basamak hassasiyeti |


**Return Value (Dönüş değeri):**

float sonuç
float



**Kullanım:** [örnek](../../../../examples/Gek/Infrastructure/Math/Decimal_class/expF_method.md)


---
### exp

Verilen ifadeyi işler ve sonucu verir.

```php
public static Decimal::exp(string $exp, int|null $scale = null): \Gek\Infrastructure\Math\Decimal
```



* Bu yöntem **statiktir**.




**Parameters (parametreler,argümanlar):**

| Parameter | Type | Description |
|-----------|------|-------------|
| `exp` | **string** | ifade |
| `scale` | **int|null** | ondalık basamak hassasiyeti |


**Return Value (Dönüş değeri):**

Decimal değer
\Gek\Infrastructure\Math\Decimal



**Kullanım:** [örnek](../../../../examples/Gek/Infrastructure/Math/Decimal_class/exp_method.md)


---


---
> 2022-04-14 tarihinde kaynak kod yorumlarından otomatik olarak oluşturulmuştur.
