---
title: \Gek\Infrastructure\Enum
footer: false
---

# Enum

Enum sınıfı



örnek: [Enum](../../../examples/Gek/Infrastructure/Enum_class/index.md)


* Full name (Tam Adı): `\Gek\Infrastructure\Enum`

**Kullanım:** [örnek](../../../examples/Gek/Infrastructure/Enum_class/index.md)



## Methods (Yöntemler)

### getEnumValue

Enum değerini döndürür.

```php
public static Enum::getEnumValue(string $key): int|null
```



* Bu yöntem **statiktir**.




**Parameters (parametreler,argümanlar):**

| Parameter | Type | Description |
|-----------|------|-------------|
| `key` | **string** | enum anahtarı (adı) |


**Return Value (Dönüş değeri):**

enum değeri
int|null



**Kullanım:** [örnek](../../../examples/Gek/Infrastructure/Enum_class/getEnumValue_method.md)


---
### getEnumValues

Enum değerlerini dizi olarak döndürür. Enum keu (adı) => enum değeri

```php
public static Enum::getEnumValues(): array|int[]
```



* Bu yöntem **statiktir**.





**Return Value (Dönüş değeri):**

enum değerleri
array|int[]



**Kullanım:** [örnek](../../../examples/Gek/Infrastructure/Enum_class/getEnumValues_method.md)


---
### getConstantsArray



```php
private static Enum::getConstantsArray(string $className): array
```



* Bu yöntem **statiktir**.




**Parameters (parametreler,argümanlar):**

| Parameter | Type | Description |
|-----------|------|-------------|
| `className` | **string** |  |


**Return Value (Dönüş değeri):**


array



**Kullanım:** [örnek](../../../examples/Gek/Infrastructure/Enum_class/getConstantsArray_method.md)


---
### checkEnumKey

Enum key in mevcut olup olmadığını döndürür.

```php
public static Enum::checkEnumKey(string $key): bool
```



* Bu yöntem **statiktir**.




**Parameters (parametreler,argümanlar):**

| Parameter | Type | Description |
|-----------|------|-------------|
| `key` | **string** | Enum key (Adı) |


**Return Value (Dönüş değeri):**

Mevcutsa true değilse false
bool



**Kullanım:** [örnek](../../../examples/Gek/Infrastructure/Enum_class/checkEnumKey_method.md)


---
### checkEnumValue

Enum değerinin mevcut olup olmadığını döndürür.

```php
public static Enum::checkEnumValue(int $value): bool
```



* Bu yöntem **statiktir**.




**Parameters (parametreler,argümanlar):**

| Parameter | Type | Description |
|-----------|------|-------------|
| `value` | **int** | Enum değeri |


**Return Value (Dönüş değeri):**

Değer mevcutsa true değilse false
bool



**Kullanım:** [örnek](../../../examples/Gek/Infrastructure/Enum_class/checkEnumValue_method.md)


---
### getEnumDocComentObjects

Enum sabitlerinin docComment lerinde oluşan bir dizi döndürür.

```php
public static Enum::getEnumDocComentObjects(): array|\Gek\Infrastructure\Reflections\DocCommentObject[]
```



* Bu yöntem **statiktir**.





**Return Value (Dönüş değeri):**


array|\Gek\Infrastructure\Reflections\DocCommentObject[]



**Kullanım:** [örnek](../../../examples/Gek/Infrastructure/Enum_class/getEnumDocComentObjects_method.md)


---


---
> 2022-04-14 tarihinde kaynak kod yorumlarından otomatik olarak oluşturulmuştur.
