---
title: \Gek\Infrastructure\ConstClassType
footer: false
---

# ConstClassType

ConstClassType Sınıfı



örnek: [ConstClassType](../../../examples/Gek/Infrastructure/ConstClassType_class/index.md)


* Full name (Tam Adı): `\Gek\Infrastructure\ConstClassType`
* Parent class (Üst Sınıf): [\Gek\Infrastructure\ConstClass](./ConstClass.md)

**Kullanım:** [örnek](../../../examples/Gek/Infrastructure/ConstClassType_class/index.md)



## Methods (Yöntemler)

### __construct

ConstClassType yapıcı method

```php
public ConstClassType::__construct(mixed $value): mixed
```

.






**Parameters (parametreler,argümanlar):**

| Parameter | Type | Description |
|-----------|------|-------------|
| `value` | **mixed** | değer |


**Return Value (Dönüş değeri):**


mixed



**Kullanım:** [örnek](../../../examples/Gek/Infrastructure/ConstClassType_class/__construct_method.md)


---
### __callStatic

sabit adından yeni bir nesne örneği oluşturur.

```php
public static ConstClassType::__callStatic( $name,  $arguments): mixed
```



* Bu yöntem **statiktir**.




**Parameters (parametreler,argümanlar):**

| Parameter | Type | Description |
|-----------|------|-------------|
| `name` | **** |  |
| `arguments` | **** |  |


**Return Value (Dönüş değeri):**


mixed



**Kullanım:** [örnek](../../../examples/Gek/Infrastructure/ConstClassType_class/__callStatic_method.md)

**Ayrıca bakınız:**

* https://www.php.net/manual/en/language.oop5.overloading.php#object.callstatic - php __callStatic sihirli yöntemi


---
### getValue

Nesneni tuttuğu değeri döndürür.

```php
public ConstClassType::getValue(): mixed
```









**Return Value (Dönüş değeri):**


mixed



**Kullanım:** [örnek](../../../examples/Gek/Infrastructure/ConstClassType_class/getValue_method.md)


---
### setValue

Nesne değerini set eder

```php
public ConstClassType::setValue(mixed $val): void
```








**Parameters (parametreler,argümanlar):**

| Parameter | Type | Description |
|-----------|------|-------------|
| `val` | **mixed** | değer |


**Return Value (Dönüş değeri):**


void



**Kullanım:** [örnek](../../../examples/Gek/Infrastructure/ConstClassType_class/setValue_method.md)


---
### __toString

Sabit adını  döndürür.

```php
public ConstClassType::__toString(): string
```









**Return Value (Dönüş değeri):**

Sabit adı
string



**Kullanım:** [örnek](../../../examples/Gek/Infrastructure/ConstClassType_class/__toString_method.md)


---


## Inherited methods (kalıtsal yöntemler)

### getConstValue

Varilen sabit ismine göre sabitin değerini verir

```php
public static ConstClass::getConstValue(string $key): mixed|null
```



* Bu yöntem **statiktir**.




**Parameters (parametreler,argümanlar):**

| Parameter | Type | Description |
|-----------|------|-------------|
| `key` | **string** | Sbit ismi |


**Return Value (Dönüş değeri):**

sabit değeri ya da bulunamazsa null döner
mixed|null



**Kullanım:** [örnek](../../../examples/Gek/Infrastructure/ConstClassType_class/getConstValue_method.md)


---
### getConstValues

Sabitleri dizi olarak göndürür

```php
public static ConstClass::getConstValues(): array
```



* Bu yöntem **statiktir**.





**Return Value (Dönüş değeri):**

sabitlerin olduğu dizi. sabit adı => sabit değeri
array



**Kullanım:** [örnek](../../../examples/Gek/Infrastructure/ConstClassType_class/getConstValues_method.md)


---
### getConstantsArray

Sınıf ismine göre sabitleri dizi olarak döndürür

```php
private static ConstClass::getConstantsArray(string $className): array
```



* Bu yöntem **statiktir**.




**Parameters (parametreler,argümanlar):**

| Parameter | Type | Description |
|-----------|------|-------------|
| `className` | **string** | sınıf adı |


**Return Value (Dönüş değeri):**

sabitlerin olduğu dizi sabit adı => sabit değeri
array



**Kullanım:** [örnek](../../../examples/Gek/Infrastructure/ConstClassType_class/getConstantsArray_method.md)


---
### checkConstKey

Sabit adının olup olmadığını kontrol eder

```php
public static ConstClass::checkConstKey(string $key): bool
```



* Bu yöntem **statiktir**.




**Parameters (parametreler,argümanlar):**

| Parameter | Type | Description |
|-----------|------|-------------|
| `key` | **string** |  |


**Return Value (Dönüş değeri):**


bool



**Kullanım:** [örnek](../../../examples/Gek/Infrastructure/ConstClassType_class/checkConstKey_method.md)


---
### checkConstValue

Sabit değerinin olup olmadığını kontrol eder.

```php
public static ConstClass::checkConstValue(mixed $value): bool
```



* Bu yöntem **statiktir**.




**Parameters (parametreler,argümanlar):**

| Parameter | Type | Description |
|-----------|------|-------------|
| `value` | **mixed** |  |


**Return Value (Dönüş değeri):**


bool



**Kullanım:** [örnek](../../../examples/Gek/Infrastructure/ConstClassType_class/checkConstValue_method.md)


---
### getConstDocCommentObjects

Sabitlerin DocCommentlerini dizi olarak verir.

```php
public static ConstClass::getConstDocCommentObjects(): array&lt;string,\Gek\Infrastructure\Reflections\DocCommentObject&gt;|\Gek\Infrastructure\Reflections\DocCommentObject[]
```



* Bu yöntem **statiktir**.





**Return Value (Dönüş değeri):**


array&lt;string,\Gek\Infrastructure\Reflections\DocCommentObject&gt;|\Gek\Infrastructure\Reflections\DocCommentObject[]



**Kullanım:** [örnek](../../../examples/Gek/Infrastructure/ConstClassType_class/getConstDocCommentObjects_method.md)


---


---
> 2022-04-14 tarihinde kaynak kod yorumlarından otomatik olarak oluşturulmuştur.
