# Gek\Infrastructure\Str:format kullanımı

## Basit Kullanuım

ilk parametrede verilen metin içindeki "{" ve "}" içine yazılan rakamlar parametre sırasıyla değiştirilir.

**örnek 1:**
```php

use Gek\Infrastructure\Str;

include_once "../../../../vendor/autoload.php";

$sonuc = Str::format('deneme {0}, {1}', 'bir', 'iki');
var_dump($sonuc); // string(15) "deneme bir, iki"
```
**örnek 2:** metin içindeki sıralama önemli değildir.
```php

use Gek\Infrastructure\Str;

include_once "../../../../vendor/autoload.php";

$sonuc = Str::format('deneme {1}, {0}', 'bir', 'iki');
var_dump($sonuc); // string(15) "deneme iki, bir"
```

**örnek 3:** metin içindeki aynı değişken birden çok kullanılabilir
```php

use Gek\Infrastructure\Str;

include_once "../../../../vendor/autoload.php";

$sonuc = Str::format('{0} deneme {1}, {0}', 'bir', 'iki');
var_dump($sonuc); // string(19) "bir deneme iki, bir"
```

## Escaping

{ ve } karakterlerini metin içinde kullanmanız gerekiyorsa ikikere yazarak escape yapmalısınız "{{" va/vaya "}}"

**örnek 1:**
```php

use Gek\Infrastructure\Str;

include_once "../../../../vendor/autoload.php";

$sonuc = Str::format('{{deneme {0}, {1}}}', 'bir', 'iki');
var_dump($sonuc); // string(17) "{deneme bir, iki}"
```
**örnek 2:**
```php

use Gek\Infrastructure\Str;

include_once "../../../../vendor/autoload.php";

$sonuc = Str::format('deneme {0}, {1} - {{{0}}}', 'bir', 'iki');
var_dump($sonuc); // string(23) "deneme bir, iki - {bir}"
```
**örnek 3:**
```php

use Gek\Infrastructure\Str;

include_once "../../../../vendor/autoload.php";

$sonuc = Str::format('deneme {0}, {1} - {{{0}}} {{{{{1}}}}}', 'bir', 'iki');
var_dump($sonuc); // string(31) "deneme bir, iki - {bir} {{iki}}"
```
**örnek 4:**
```php

use Gek\Infrastructure\Str;

include_once "../../../../vendor/autoload.php";

$sonuc = Str::format('deneme {0}, {1} - {{{0}}} {{{{{{1}}}}}}', 'bir', 'iki');
var_dump($sonuc); // string(31) "deneme bir, iki - {bir} {{{1}}}"
```
## Parametreler yerine array kullanımı

Bazen paremetreler yerine parametreleri içeren bir array kullanmak isteyebilirsiniz.

**örnek 1:**
```php

use Gek\Infrastructure\Str;

include_once "../../../../vendor/autoload.php";

$parametreler = array('bir', 'iki');
$sonuc = Str::format('deneme {0}, {1}', $parametreler);
var_dump($sonuc); // string(15) "deneme bir, iki"
```


## Parametre Tipleri
parametreler tiplerine göre farklı şekillerde render edilirler.

