<?php


namespace Gek\Filesystem\Tests;


use Gek\Filesystem\Exceptions\FileNotFoundException;
use PHPUnit\Framework\TestCase;

/**
 * Class FileNotFoundExceptionTest
 * @package Gek\Filesystem\Tests
 */
class FileNotFoundExceptionTest extends TestCase
{

    public function testAutoGeneratedMessage():void {
        $exception = new FileNotFoundException();
        $this->assertEquals(
            'Dosya bulunamadı.',
            $exception->getMessage()
        );
        $exception = new FileNotFoundException('',0,null,'/test/path/dummy.txt');
        $this->assertEquals(
            'Dosya bulunamadı. Dosya yolu: "/test/path/dummy.txt"',
            $exception->getMessage()
        );
    }

    public function testCustomMessage():void {
        $exception = new FileNotFoundException('Custom Message.');
        $this->assertEquals(
            'Custom Message.',
            $exception->getMessage()
        );
    }

}
