<?php


namespace Gek\Filesystem\Exceptions;


use Gek\Infrastructure\Str;
use Throwable;

/**
 * Class FileNotFoundException
 * @package Gek\Filesystem\Exceptions
 */
class FileNotFoundException extends IOException
{
    /**
     * {@inheritDoc}
     */
    public function __construct($message = "", $code = 0, Throwable $previous = null, ?string $path = null)
    {
        if (empty($message)) {
            if ($path === null) {
                $message = 'Dosya bulunamadı.';
            } else {
                $message = Str::format('Dosya bulunamadı. Dosya yolu: "{0}"', $path);
            }
        }
        parent::__construct($message, $code, $previous, $path);
    }

}
