<?php


namespace Gek\FileFinder\Tests\Iterators;


use Gek\FileFinder\Iterators\GekRecursiveDirectoryIterator;
use PHPUnit\Framework\TestCase;

class GekRecursiveDirectoryIteratorTest extends TestCase
{



    /**
     * @group network
     */
    public function testSeekOnFtp()
    {
        try {
            $i = new GekRecursiveDirectoryIterator('ftp://speedtest.tele2.net/', \RecursiveDirectoryIterator::SKIP_DOTS);
        } catch (\UnexpectedValueException $e) {
            $this->markTestSkipped('Unsupported stream "ftp".');
        }

        $contains = [
            'ftp://speedtest.tele2.net'.\DIRECTORY_SEPARATOR.'1000GB.zip',
            'ftp://speedtest.tele2.net'.\DIRECTORY_SEPARATOR.'100GB.zip',
        ];
        $actual = [];

        $i->seek(0);
        $actual[] = $i->getPathname();

        $i->seek(1);
        $actual[] = $i->getPathname();

        $this->assertEquals($contains, $actual);
    }

    /**
     * @group network
     */
    public function testRewindOnFtp()
    {
        try {
            $i = new GekRecursiveDirectoryIterator('ftp://speedtest.tele2.net/', \RecursiveDirectoryIterator::SKIP_DOTS);
        } catch (\UnexpectedValueException $e) {
            $this->markTestSkipped('Unsupported stream "ftp".');
        }
        $i->seek(0);
        $i->rewind();

        $this->assertTrue(true);
    }

}