<?php


namespace Gek\FileFinder;


use RuntimeException;

class FileInfo extends \SplFileInfo
{

    #region fields

    private $relativePath;

    private $relativePathname;

    #endregion fields

    #region ctor

    public function __construct(string $file_name, string $relativePath, string $relativePathname)
    {
        parent::__construct($file_name);
        $this->relativePath = $relativePath;
        $this->relativePathname = $relativePathname;
    }



    #endregion ctor

    #region properties

    /**
     * @return string
     */
    public function getRelativePath(): string
    {
        return $this->relativePath;
    }

    /**
     * @return string
     */
    public function getRelativePathname(): string
    {
        return $this->relativePathname;
    }

    #endregion properties

    #region Methods

    /**
     * @return string
     */
    public function getFilenameWithoutExtension(): string
    {
        $filename = $this->getFilename();
        return pathinfo($filename, \PATHINFO_FILENAME);
    }

    /**
     * @return false|string
     */
    public function getContents()
    {
        set_error_handler(function ($type, $msg) use (&$error) { $error = $msg; });
        $content = file_get_contents($this->getPathname());
        restore_error_handler();
        if (false === $content) {
            throw new RuntimeException($error);
        }

        return $content;
    }

    #endregion Methods

}