<?php


namespace Gek\FileFinder\Iterators;


use RecursiveIteratorIterator;
use Traversable;

class GekRecursiveIteratorIterator extends \RecursiveIteratorIterator
{
    /**
     * @var callable|null
     */
    protected $dephtFilterFn = null;

    /**
     * GekRecursiveIteratorIterator constructor.
     * @param Traversable $iterator
     * @param int $mode
     * @param int $flags
     */
    public function __construct(Traversable $iterator, $mode = self::LEAVES_ONLY, $flags = 0)
    {
        parent::__construct($iterator, $mode, $flags);
    }

    public function next()
    {
        parent::next();
        $fn = $this->dephtFilterFn;
        if($fn !== null){
            $found = false;
            while ((! $found) && $this->valid()){
                $found = $fn($this->getDepth());
                if(! $found){
                    parent::next();
                }
            }
        }
    }

    /**
     * @return callable|null
     */
    public function getDephtFilterFn(): ?callable
    {
        return $this->dephtFilterFn;
    }

    /**
     * @param callable|null $dephtFilterFn
     */
    public function setDephtFilterFn(?callable $dephtFilterFn): void
    {
        $this->dephtFilterFn = $dephtFilterFn;
    }


}