<?php


namespace Gek\Collections\Tests;


use Gek\Collections\ArrayList;
use Gek\Collections\FixedArrayList;
use Gek\Collections\Tests\Fixtures\MockListItemType;
use Gek\Collections\IList;
use Gek\Collections\Tests\Fixtures\MockForTypedListWrapper;
use PHPUnit\Framework\TestCase;

/**
 * Class TypedListWrapperTest
 * @package Gek\Collections\Tests
 */
class TypedListWrapperTest extends TestCase
{

    public function testCtor():void {
        $list = new ArrayList();
        $mock = new MockForTypedListWrapper($list,'int');

        $this->assertEquals(
            'int',
            $mock->getItemType()
        );
        $this->assertEquals(
            $list,
            $mock->getInnerList()
        );
        $this->assertTrue(
            $list === $mock->getInnerList()
        );

        $this->assertEquals(
            $list,
            $mock->getEnm()
        );
        $this->assertTrue(
            $list === $mock->getEnm()
        );

        $list = new FixedArrayList();
        $mock = new MockForTypedListWrapper($list,'Boolean');

        $this->assertEquals(
            'bool',
            $mock->getItemType()
        );
        $this->assertEquals(
            $list,
            $mock->getInnerList()
        );
        $this->assertTrue(
            $list === $mock->getInnerList()
        );

        /**/
        $mock = new MockForTypedListWrapper($list,MockListItemType::class);

        $this->assertEquals(
            MockListItemType::class,
            $mock->getItemType()
        );
        $this->assertEquals(
            $list,
            $mock->getInnerList()
        );
        $this->assertTrue(
            $list === $mock->getInnerList()
        );

        $this->assertEquals(
            $list,
            $mock->getEnm()
        );
        $this->assertTrue(
            $list === $mock->getEnm()
        );
    }

    public function testGetInnerList():void {
        $list = new ArrayList();
        $mock = new MockForTypedListWrapper($list,'int');

        $this->assertEquals(
            $list,
            $mock->getInnerList()
        );
        $this->assertTrue(
            $list === $mock->getInnerList()
        );
        $this->assertInstanceOf(
            IList::class,
            $mock->getInnerList()
        );
    }

    #region serializable

    public function testSerializable(){
        $list = new ArrayList(range(0,9));
        $mock = new MockForTypedListWrapper($list,'int');

        $ser = serialize($mock);
        $this->assertNotEmpty($ser);
        $this->assertIsString($ser);
        /** @var  MockForTypedListWrapper $unSer */
        $unSer = unserialize($ser);
        $this->assertTrue($unSer instanceof MockForTypedListWrapper);
        $this->assertEquals($mock , $unSer);
        $this->assertFalse($mock === $unSer);
        $this->assertEquals(
            $mock->toArray(true),
            $unSer->toArray(true)
        );
        $this->assertEquals(
            $list->toArray(),
            $unSer->toArray(true)
        );
    }

    public function testNonSerializable1(){
        $list = new ArrayList();
        $mock = new MockForTypedListWrapper($list,'closure');
        $this->expectException(\LogicException::class);
        $this->expectExceptionMessage('Öğe tipi (closure) serileştirilebilir bir tip değil.');
        $ser = serialize($mock);

    }
    public function testNonSerializable2(){
        $list = new ArrayList();
        $mock = new MockForTypedListWrapper($list,'callable');
        $this->expectException(\LogicException::class);
        $this->expectExceptionMessage('Öğe tipi (callable) serileştirilebilir bir tip değil.');
        $ser = serialize($mock);

    }

    public function testNonSerializable3(){
        $list = new ArrayList();
        $mock = new MockForTypedListWrapper($list,'resource');
        $this->expectException(\LogicException::class);
        $this->expectExceptionMessage('Öğe tipi (resource) serileştirilebilir bir tip değil.');
        $ser = serialize($mock);

    }

    #endregion serializable

}
