<?php


namespace Gek\Collections\Typed;


use Gek\Collections\ArrayList;
use Gek\Collections\TypedListWrapper;

/**
 * Class ObjectList
 * @package Gek\Collections\Typed
 */
class ObjectList extends TypedListWrapper
{
    #region ctor

    /**
     * IntList constructor.
     * @param object ...$items
     */
    public function __construct(object ...$items)
    {
        parent::__construct(new ArrayList(), 'object');
        $this->addRange(...$items);
    }

    #endregion ctor

    #region methods

    /**
     * @param object $item
     */
    public function add(object $item):void{
        $this->innerList->add($item);
    }

    /**
     * @param object ...$items
     */
    public function addRange(object ...$items):void{
        $this->innerList->addRange($items);
    }

    /**
     * @param object $item
     * @return bool
     */
    public function contains(object $item):bool{
        return $this->innerList->contains($item);
    }

    /**
     * @param object $item
     * @return bool
     */
    public function remove(object $item):bool{
        return $this->innerList->remove($item);
    }

    /**
     * @param object $item
     * @return int
     */
    public function indexOf(object $item): int{
        return $this->innerList->indexOf($item);
    }

    /**
     * @param int $index
     * @param object $item
     */
    public function insert(int $index, object $item): void{
        $this->innerList->insert($index,$item);
    }

    /**
     * @param int $index
     * @return object
     */
    public function getAt(int $index):object {
        return $this->innerList[$index];
    }

    /**
     * @param int $index
     * @param object $item
     */
    public function setAt(int $index, object $item):void{
        $this->innerList[$index] = $item;
    }

    /**
     * @param int $index
     * @param object ...$items
     */
    public function insertRange(int $index, object ...$items):void{
        $this->innerList->insertRange($index,$items);
    }


    #endregion methods

}
