<?php


namespace Gek\Collections\Typed;


use Gek\Collections\ArrayList;
use Gek\Collections\TypedListWrapper;

/**
 * Class CallableList
 * @package Gek\Collections\Typed
 */
class CallableList extends TypedListWrapper
{
    #region ctor

    /**
     * IntList constructor.
     * @param callable ...$items
     */
    public function __construct(callable ...$items)
    {
        parent::__construct(new ArrayList(), 'callable');
        $this->addRange(...$items);
    }

    #endregion ctor

    #region methods

    /**
     * @param callable $item
     */
    public function add(callable $item):void{
        $this->innerList->add($item);
    }

    /**
     * @param callable ...$items
     */
    public function addRange(callable ...$items):void{
        $this->innerList->addRange($items);
    }



    /**
     * @param callable $item
     * @return bool
     */
    public function contains(callable $item):bool{
        return $this->innerList->contains($item);
    }

    /**
     * @param callable $item
     * @return bool
     */
    public function remove(callable $item):bool{
        return $this->innerList->remove($item);
    }

    /**
     * @param callable $item
     * @return int
     */
    public function indexOf(callable $item): int{
        return $this->innerList->indexOf($item);
    }

    /**
     * @param int $index
     * @param callable $item
     */
    public function insert(int $index, callable $item): void{
        $this->innerList->insert($index,$item);
    }

    /**
     * @param int $index
     * @return callable
     */
    public function getAt(int $index):callable {
        return $this->innerList[$index];
    }

    /**
     * @param int $index
     * @param callable $item
     */
    public function setAt(int $index, callable $item):void{
        $this->innerList[$index] = $item;
    }

    /**
     * @param int $index
     * @param callable ...$items
     */
    public function insertRange(int $index, callable ...$items):void{
        $this->innerList->insertRange($index,$items);
    }


    #endregion methods

}
