<?php


namespace Gek\Collections\Typed;


use Gek\Collections\Dictionary;
use Gek\Collections\Enumerable;
use Gek\Collections\TypedDictionaryWrapper;

/**
 * Class StringDictionary
 * @package Gek\Collections\Typed
 */
class StringDictionary extends TypedDictionaryWrapper
{
    #region ctor
    /**
     * StringDictionary constructor.e
     * @param Dictionary|array|Enumerable|\Traversable|null $values
     */
    public function __construct($values = null)
    {
        parent::__construct(new Dictionary(), 'string');
        if($values != null)
        {
            $this->addRange($values);
        }
    }
    #endregion ctor

    #region methods

    /**
     * @param string $item
     */
    public function add(string $item):void {
        $this->innerDictionary->add($item);
    }


    /**
     * @param Dictionary|array|Enumerable|\Traversable $items
     */
    public function addRange($items): void
    {
        foreach ($items as $key => $value){
            $this->addKeyValue($key,$value);
        }
    }

    /**
     * @param string $item
     * @return bool
     */
    public function contains(string $item): bool{
        return $this->innerDictionary->contains($item);
    }

    /**
     * @param string $item
     * @return bool
     */
    public function remove(string $item): bool{
        return $this->innerDictionary->remove($item);
    }

    /**
     * @param string $key
     * @param string $value
     */
    public function addKeyValue(string $key, string $value): void{
        $this->innerDictionary->addKeyValue($key,$value);
    }

    /**
     * @param string $key
     * @param string $value
     * @return bool
     */
    public function tryAddKeyValue(string $key, string $value):bool{
        return $this->innerDictionary->tryAddKeyValue($key,$value);
    }

    /**
     * @param string $key
     * @return string
     */
    public function getByKey(string $key):string {
        return $this->innerDictionary[$key];
    }

    /**
     * @param string $key
     * @param string $item
     */
    public function setByKey(string $key, string $item):void {
        $this->innerDictionary[$key] = $item;
    }

    #endregion methods
}
