<?php


namespace Gek\Collections\Typed;


use Gek\Collections\Dictionary;
use Gek\Collections\Enumerable;
use Gek\Collections\TypedDictionaryWrapper;

/**
 * Class ObjectDictionary
 * @package Gek\Collections\Typed
 */
class ObjectDictionary extends TypedDictionaryWrapper
{

    #region ctor
    /**
     * ObjectDictionary constructor.
     * @param Dictionary|array|Enumerable|\Traversable|null $values
     */
    public function __construct($values = null)
    {
        parent::__construct(new Dictionary(), 'object');
        if($values != null)
        {
            $this->addRange($values);
        }
    }
    #endregion ctor

    #region methods

    /**
     * @param object $item
     */
    public function add(object $item):void {
        $this->innerDictionary->add($item);
    }


    /**
     * @param Dictionary|array|Enumerable|\Traversable $items
     */
    public function addRange($items): void
    {
        foreach ($items as $key => $value){
            $this->addKeyValue($key,$value);
        }
    }

    /**
     * @param object $item
     * @return bool
     */
    public function contains(object $item): bool{
        return $this->innerDictionary->contains($item);
    }

    /**
     * @param object $item
     * @return bool
     */
    public function remove(object $item): bool{
        return $this->innerDictionary->remove($item);
    }

    /**
     * @param string $key
     * @param object $value
     */
    public function addKeyValue(string $key, object $value): void{
        $this->innerDictionary->addKeyValue($key,$value);
    }

    /**
     * @param string $key
     * @param object $value
     * @return bool
     */
    public function tryAddKeyValue(string $key, object $value):bool{
        return $this->innerDictionary->tryAddKeyValue($key,$value);
    }

    /**
     * @param string $key
     * @return object
     */
    public function getByKey(string $key):object {
        return $this->innerDictionary[$key];
    }

    /**
     * @param string $key
     * @param object $item
     */
    public function setByKey(string $key, object $item):void {
        $this->innerDictionary[$key] = $item;
    }

    #endregion methods

}
