<?php


namespace Gek\Collections\Traits;


use Closure;
use Gek\Infrastructure\Str;
use phpDocumentor\Reflection\Types\Self_;

/**
 * Trait TypedCollectionTrait
 * @package Gek\Collections\Traits
 */
trait TypedCollectionTrait
{

    #region fields

    /**
     * Öğe tipi
     * @var string
     */
    protected string $itemType;

    /**
     * @var bool
     */
    protected bool $scalarItemType;

    /**
     * @var Closure
     */
    protected Closure $typeCheckerFn;

    /**
     * @var array
     */
    protected static array $scalarTypesArray = [
        'int',
        'integer',
        'float',
        'bool',
        'boolean',
        'object',
        'array',
        'string',
        'callable',
        'closure',
        'iterable',
        'resource'
    ];

    #endregion fields

    #region methods

    /**
     * @return string
     */
    public function getItemType():string {
        return $this->itemType;
    }

    /**
     * @return bool
     */
    public function isScalarItemType():bool {
        return $this->scalarItemType;
    }

    /**
     * @param $item
     * @return bool
     */
    public function checkItemType($item): bool
    {

        return call_user_func_array($this->typeCheckerFn,[$item]);
    }



    #endregion methods

    #region utils
    /**
     * @param string $type
     * @return bool
     */
    protected function initalizeType(string $type): bool
    {
        $typeStr = Str::toLowerCase(trim($type));
        if ($typeStr === '') {
            return false;
        }
        $res = false;
        $isScalar = null;
        /** @var callable $checkFn */
        $checkFn = null;
        if (in_array($typeStr, self::$scalarTypesArray)) {
            $res = true;
            if($typeStr == 'integer'){
                $typeStr = 'int';
            }elseif ($typeStr == 'boolean'){
                $typeStr = 'bool';
            }
            $type = $typeStr;
            $isScalar = true;
            switch ($type) {
                case 'int':
                case 'integer':
                    $checkFn = 'is_int';
                    break;
                case 'float':
                    $checkFn = 'is_float';
                    break;
                case 'bool':
                case 'boolean':
                    $checkFn = 'is_bool';
                    break;
                case 'string':
                    $checkFn = 'is_string';
                    break;
                case 'callable':
                case 'closure':
                    $checkFn = 'is_callable';
                    break;
                case 'object':
                    $checkFn = 'is_object';
                    break;
                case 'array':
                    $checkFn = 'is_array';
                    break;
                case 'resource':
                    $checkFn = 'is_resource';
                    break;
                case 'iterable':
                    $checkFn = 'is_iterable';
                    break;
            }
            $res = $checkFn !== null;
        } elseif (class_exists($type)) {
            $res = true;
            $isScalar = false;
            $checkFn = function ($item) {
                if ($item instanceof $this->itemType) {
                    return true;
                }
                return false;
            };
        }
        if ($res) {
            $this->itemType = $type;
            $this->scalarItemType = (bool)$isScalar;
            $this->typeCheckerFn = ($checkFn instanceof Closure) ?
                $checkFn : Closure::fromCallable($checkFn);
        }
        return $res;
    }
    #endregion utils

}
