<?php


namespace Gek\Collections\Tests;


use Gek\Collections\ArrayList;
use Gek\Collections\FixedArrayList;
use Gek\Collections\Tests\Fixtures\MockListItemType;
use Gek\Collections\IList;
use Gek\Collections\Tests\Fixtures\MockForTypedListWrapper;
use PHPUnit\Framework\TestCase;

/**
 * Class TypedListWrapperTest
 * @package Gek\Collections\Tests
 */
class TypedListWrapperTest extends TestCase
{

    public function testCtor():void {
        $list = new ArrayList();
        $mock = new MockForTypedListWrapper($list,'int');

        $this->assertEquals(
            'int',
            $mock->getItemType()
        );
        $this->assertEquals(
            $list,
            $mock->getInnerList()
        );
        $this->assertTrue(
            $list === $mock->getInnerList()
        );

        $this->assertEquals(
            $list,
            $mock->getEnm()
        );
        $this->assertTrue(
            $list === $mock->getEnm()
        );

        $list = new FixedArrayList();
        $mock = new MockForTypedListWrapper($list,'Boolean');

        $this->assertEquals(
            'bool',
            $mock->getItemType()
        );
        $this->assertEquals(
            $list,
            $mock->getInnerList()
        );
        $this->assertTrue(
            $list === $mock->getInnerList()
        );

        /**/
        $mock = new MockForTypedListWrapper($list,MockListItemType::class);

        $this->assertEquals(
            MockListItemType::class,
            $mock->getItemType()
        );
        $this->assertEquals(
            $list,
            $mock->getInnerList()
        );
        $this->assertTrue(
            $list === $mock->getInnerList()
        );

        $this->assertEquals(
            $list,
            $mock->getEnm()
        );
        $this->assertTrue(
            $list === $mock->getEnm()
        );
    }

    public function testGetInnerList():void {
        $list = new ArrayList();
        $mock = new MockForTypedListWrapper($list,'int');

        $this->assertEquals(
            $list,
            $mock->getInnerList()
        );
        $this->assertTrue(
            $list === $mock->getInnerList()
        );
        $this->assertInstanceOf(
            IList::class,
            $mock->getInnerList()
        );
    }

}
