<?php


namespace Gek\Collections\Tests;


use Gek\Collections\ArrayList;
use Gek\Collections\Dictionary;
use Gek\Collections\FixedArrayList;
use Gek\Collections\Tests\Fixtures\MockDictionaryItemType;
use Gek\Collections\Tests\Fixtures\MockForTypedDictionaryWrapper;
use Gek\Collections\Tests\Fixtures\MockForTypedListWrapper;
use Gek\Collections\Tests\Fixtures\MockListItemType;
use Gek\Collections\IDictionary;
use Gek\Collections\IList;
use PHPUnit\Framework\TestCase;

class TypedDictionaryWrapperTest extends TestCase
{

    public function testCtor():void {
        $dictionary = new Dictionary();
        $mock = new MockForTypedDictionaryWrapper($dictionary,'int');

        $this->assertEquals(
            'int',
            $mock->getItemType()
        );
        $this->assertEquals(
            $dictionary,
            $mock->getInnerDictionary()
        );
        $this->assertTrue(
            $dictionary === $mock->getInnerDictionary()
        );

        $this->assertEquals(
            $dictionary,
            $mock->getEnm()
        );
        $this->assertTrue(
            $dictionary === $mock->getEnm()
        );



        /**/
        $mock = new MockForTypedDictionaryWrapper($dictionary,MockDictionaryItemType::class);

        $this->assertEquals(
            MockDictionaryItemType::class,
            $mock->getItemType()
        );

        $this->assertTrue(
            $dictionary === $mock->getInnerDictionary()
        );

        $this->assertTrue(
            $dictionary === $mock->getEnm()
        );
    }

    public function testGetInnerDictionary():void {
        $list = new Dictionary();
        $mock = new MockForTypedDictionaryWrapper($list,'int');

        $this->assertEquals(
            $list,
            $mock->getInnerDictionary()
        );
        $this->assertTrue(
            $list === $mock->getInnerDictionary()
        );
        $this->assertInstanceOf(
            IDictionary::class,
            $mock->getInnerDictionary()
        );
    }

}