<?php


namespace Gek\Collections\Typed;


use Gek\Collections\ArrayList;
use Gek\Collections\TypedListWrapper;

/**
 * Class StringList
 * @package Gek\Collections\Typed
 */
class StringList extends TypedListWrapper
{

    #region ctor

    /**
     * IntList constructor.
     * @param string ...$items
     */
    public function __construct(string ...$items)
    {
        parent::__construct(new ArrayList(), 'string');
        $this->addRange(...$items);
    }

    #endregion ctor

    #region methods

    /**
     * @param string $item
     */
    public function add(string $item):void{
        $this->innerList->add($item);
    }

    /**
     * @param string ...$items
     */
    public function addRange(string ...$items):void{
        $this->innerList->addRange($items);
    }


    /**
     * @param string $item
     * @return bool
     */
    public function contains(string $item):bool{
        return $this->innerList->contains($item);
    }

    /**
     * @param string $item
     * @return bool
     */
    public function remove(string $item):bool{
        return $this->innerList->remove($item);
    }

    /**
     * @param string $item
     * @return int
     */
    public function indexOf(string $item): int{
        return $this->innerList->indexOf($item);
    }

    /**
     * @param int $index
     * @param string $item
     */
    public function insert(int $index, string $item): void{
        $this->innerList->insert($index,$item);
    }

    /**
     * @param int $index
     * @return string
     */
    public function getAt(int $index):string {
        return $this->innerList[$index];
    }

    /**
     * @param int $index
     * @param string $item
     */
    public function setAt(int $index, string $item):void{
        $this->innerList[$index] = $item;
    }

    /**
     * @param int $index
     * @param string ...$items
     */
    public function insertRange(int $index, string ...$items):void{
        $this->innerList->insertRange($index,$items);
    }

    #endregion methods

}
