<?php


namespace Gek\Collections\Typed;


use Gek\Collections\ArrayList;
use Gek\Collections\TypedListWrapper;

/**
 * Class IntList
 * @package Gek\Collections\Typed
 */
class IntList extends TypedListWrapper
{

    #region ctor

    /**
     * IntList constructor.
     * @param int ...$items
     */
    public function __construct(int ...$items)
    {
        parent::__construct(new ArrayList(), 'int');
        $this->addRange(...$items);
    }

    #endregion ctor

    #region methods

    /**
     * @param int $item
     */
    public function add(int $item):void{
        $this->innerList->add($item);
    }

    /**
     * @param int ...$items
     */
    public function addRange(int ...$items):void{
        $this->innerList->addRange($items);
    }

    /**
     * @param int $item
     * @return bool
     */
    public function contains(int $item):bool{
        return $this->innerList->contains($item);
    }

    /**
     * @param int  $item
     * @return bool
     */
    public function remove(int $item):bool{
        return $this->innerList->remove($item);
    }

    /**
     * @param int $item
     * @return int
     */
    public function indexOf(int $item): int{
        return $this->innerList->indexOf($item);
    }

    /**
     * @param int $index
     * @param int $item
     */
    public function insert(int $index, int $item): void{
        $this->innerList->insert($index,$item);
    }

    /**
     * @param int $index
     * @return int
     */
    public function getAt(int $index):int {
        return $this->innerList[$index];
    }

    /**
     * @param int $index
     * @param int $item
     */
    public function setAt(int $index, int $item):void{
        $this->innerList[$index] = $item;
    }

    /**
     * @param int $index
     * @param int ...$items
     */
    public function insertRange(int $index, int ...$items):void{
        $this->innerList->insertRange($index,$items);
    }



    #endregion methods

}
