<?php


namespace Gek\Collections\Typed;


use Gek\Collections\Dictionary;
use Gek\Collections\Enumerable;
use Gek\Collections\TypedDictionaryWrapper;

/**
 * Class IntDictionary
 * @package Gek\Collections\Typed
 */
class IntDictionary extends TypedDictionaryWrapper
{

    #region ctor
    /**
     * IntDictionary constructor.e
     * @param Dictionary|array|Enumerable|\Traversable|null $values
     */
    public function __construct($values = null)
    {
        parent::__construct(new Dictionary(), 'int');
        if($values != null)
        {
            $this->addRange($values);
        }
    }
    #endregion ctor

    #region methods

    /**
     * @param int $item
     */
    public function add(int $item):void {
        $this->innerDictionary->add($item);
    }


    /**
     * @param Dictionary|array|Enumerable|\Traversable $items
     */
    public function addRange($items): void
    {
        foreach ($items as $key => $value){
            $this->addKeyValue($key,$value);
        }
    }

    /**
     * @param int $item
     * @return bool
     */
    public function contains(int $item): bool{
        return $this->innerDictionary->contains($item);
    }

    /**
     * @param int $item
     * @return bool
     */
    public function remove(int $item): bool{
        return $this->innerDictionary->remove($item);
    }

    /**
     * @param string $key
     * @param int $value
     */
    public function addKeyValue(string $key, int $value): void{
        $this->innerDictionary->addKeyValue($key,$value);
    }

    /**
     * @param string $key
     * @param int $value
     * @return bool
     */
    public function tryAddKeyValue(string $key, int $value):bool{
        return $this->innerDictionary->tryAddKeyValue($key,$value);
    }

    /**
     * @param string $key
     * @return int
     */
    public function getByKey(string $key):int {
        return $this->innerDictionary[$key];
    }

    /**
     * @param string $key
     * @param int $item
     */
    public function setByKey(string $key, int $item):void {
        $this->innerDictionary[$key] = $item;
    }

    #endregion methods

}
