<?php


namespace Gek\Collections\Typed;


use Gek\Collections\ArrayList;
use Gek\Collections\IEnumerable;
use Gek\Collections\TypedListWrapper;

/**
 * Class EnumerableList
 * @package Gek\Collections\Typed
 */
class EnumerableList extends TypedListWrapper
{
    #region ctor

    /**
     * IntList constructor.
     * @param IEnumerable ...$items
     */
    public function __construct(IEnumerable ...$items)
    {
        parent::__construct(new ArrayList(), IEnumerable::class);
        $this->addRange(...$items);
    }

    #endregion ctor

    #region methods

    /**
     * @param IEnumerable $item
     */
    public function add(IEnumerable $item):void{
        $this->innerList->add($item);
    }

    /**
     * @param IEnumerable ...$items
     */
    public function addRange(IEnumerable ...$items):void{
        $this->innerList->addRange($items);
    }


    /**
     * @param IEnumerable $item
     * @return bool
     */
    public function contains(IEnumerable $item):bool{
        return $this->innerList->contains($item);
    }

    /**
     * @param IEnumerable $item
     * @return bool
     */
    public function remove(IEnumerable $item):bool{
        return $this->innerList->remove($item);
    }

    /**
     * @param IEnumerable $item
     * @return int
     */
    public function indexOf(IEnumerable $item): int{
        return $this->innerList->indexOf($item);
    }

    /**
     * @param int $index
     * @param IEnumerable $item
     */
    public function insert(int $index, IEnumerable $item): void{
        $this->innerList->insert($index,$item);
    }

    /**
     * @param int $index
     * @return IEnumerable
     */
    public function getAt(int $index):IEnumerable {
        return $this->innerList[$index];
    }

    /**
     * @param int $index
     * @param IEnumerable $item
     */
    public function setAt(int $index, IEnumerable $item):void{
        $this->innerList[$index] = $item;
    }

    /**
     * @param int $index
     * @param IEnumerable ...$items
     */
    public function insertRange(int $index, IEnumerable ...$items):void{
        $this->innerList->insertRange($index,$items);
    }



    #endregion methods

}

