<?php


namespace Gek\Collections\Typed;


use Gek\Collections\Dictionary;
use Gek\Collections\Enumerable;
use Gek\Collections\IEnumerable;
use Gek\Collections\TypedDictionaryWrapper;

/**
 * Class EnumerableDictionary
 * @package Gek\Collections\Typed
 */
class EnumerableDictionary extends TypedDictionaryWrapper
{

    #region ctor
    /**
     * EnumerableDictionary constructor.
     * @param Dictionary|array|Enumerable|\Traversable|null $values
     */
    public function __construct($values = null)
    {
        parent::__construct(new Dictionary(), IEnumerable::class);
        if($values != null)
        {
            $this->addRange($values);
        }
    }
    #endregion ctor

    #region methods

    /**
     * @param IEnumerable $item
     */
    public function add(IEnumerable $item):void {
        $this->innerDictionary->add($item);
    }


    /**
     * @param Dictionary|array|Enumerable|\Traversable $items
     */
    public function addRange($items): void
    {
        foreach ($items as $key => $value){
            $this->addKeyValue($key,$value);
        }
    }

    /**
     * @param IEnumerable $item
     * @return bool
     */
    public function contains(IEnumerable $item): bool{
        return $this->innerDictionary->contains($item);
    }

    /**
     * @param IEnumerable $item
     * @return bool
     */
    public function remove(IEnumerable $item): bool{
        return $this->innerDictionary->remove($item);
    }

    /**
     * @param string $key
     * @param IEnumerable $value
     */
    public function addKeyValue(string $key, IEnumerable $value): void{
        $this->innerDictionary->addKeyValue($key,$value);
    }

    /**
     * @param string $key
     * @param IEnumerable $value
     * @return bool
     */
    public function tryAddKeyValue(string $key, IEnumerable $value):bool{
        return $this->innerDictionary->tryAddKeyValue($key,$value);
    }

    /**
     * @param string $key
     * @return IEnumerable
     */
    public function getByKey(string $key):IEnumerable {
        return $this->innerDictionary[$key];
    }

    /**
     * @param string $key
     * @param IEnumerable $item
     */
    public function setByKey(string $key, IEnumerable $item):void {
        $this->innerDictionary[$key] = $item;
    }

    #endregion methods

}
