<?php


namespace Gek\Collections\Typed;


use Gek\Collections\Dictionary;
use Gek\Collections\Enumerable;
use Gek\Collections\TypedDictionaryWrapper;

/**
 * Class CallableDictionary
 * @package Gek\Collections\Typed
 */
class CallableDictionary extends TypedDictionaryWrapper
{
    #region ctor
    /**
     * CallableDictionary constructor.
     * @param Dictionary|array|Enumerable|\Traversable|null $values
     */
    public function __construct($values = null)
    {
        parent::__construct(new Dictionary(), 'callable');
        if($values != null)
        {
            $this->addRange($values);
        }
    }
    #endregion ctor

    #region methods

    /**
     * @param callable $item
     */
    public function add(callable $item):void {
        $this->innerDictionary->add($item);
    }


    /**
     * @param Dictionary|array|Enumerable|\Traversable $items
     */
    public function addRange($items): void
    {
        foreach ($items as $key => $value){
            $this->addKeyValue($key,$value);
        }
    }

    /**
     * @param callable $item
     * @return bool
     */
    public function contains(callable $item): bool{
        return $this->innerDictionary->contains($item);
    }

    /**
     * @param callable $item
     * @return bool
     */
    public function remove(callable $item): bool{
        return $this->innerDictionary->remove($item);
    }

    /**
     * @param string $key
     * @param callable $value
     */
    public function addKeyValue(string $key, callable $value): void{
        $this->innerDictionary->addKeyValue($key,$value);
    }

    /**
     * @param string $key
     * @param callable $value
     * @return bool
     */
    public function tryAddKeyValue(string $key, callable $value):bool{
        return $this->innerDictionary->tryAddKeyValue($key,$value);
    }

    /**
     * @param string $key
     * @return callable
     */
    public function getByKey(string $key):callable {
        return $this->innerDictionary[$key];
    }

    /**
     * @param string $key
     * @param callable $item
     */
    public function setByKey(string $key, callable $item):void {
        $this->innerDictionary[$key] = $item;
    }

    #endregion methods
}
