<?php


namespace Gek\Collections;


use ArrayAccess;

/**
 * Interface IDictionary
 * @package Gek\Collections
 */
interface IDictionary extends ICollection, ArrayAccess
{
    /**
     * @param mixed $key
     * @param mixed $value
     */
    public function addKeyValue($key,$value):void;

    /**
     * @param $key
     * @param $value
     */
    public function tryAddKeyValue($key, $value):bool;

    /**
     * @param $key
     * @return bool
     */
    public function containsKey($key):bool;

    /**
     * @param mixed $key
     * @return bool
     */
    public function removeByKey($key):bool ;

    /**
     * @return Enumerable
     */
    public function getKeys():Enumerable;

    /**
     * @return Enumerable
     */
    public function getValues():Enumerable;


}
