<?php


namespace Gek\Collections\Typed;


use Gek\Collections\ArrayList;
use Gek\Collections\TypedListWrapper;

/**
 * Class TArrayList
 * @package Gek\Collections\Typed
 *
 */
class TArrayList extends TypedListWrapper
{

    #region ctor

    /**
     * IntList constructor.
     * @param array ...$items
     */
    public function __construct(array ...$items)
    {
        parent::__construct(new ArrayList(), 'array');
        $this->addRange(...$items);
    }

    #endregion ctor

    #region methods

    /**
     * @param array $item
     */
    public function add(array $item):void{
        $this->innerList->add($item);
    }

    /**
     * @param array ...$items
     */
    public function addRange(array ...$items):void{
        $this->innerList->addRange($items);
    }

    /**
     * @param array $item
     * @return bool
     */
    public function contains(array $item):bool{
        return $this->innerList->contains($item);
    }

    /**
     * @param array $item
     * @return bool
     */
    public function remove(array $item):bool{
        return $this->innerList->remove($item);
    }

    /**
     * @param array $item
     * @return int
     */
    public function indexOf(array $item): int{
        return $this->innerList->indexOf($item);
    }

    /**
     * @param int $index
     * @param array $item
     */
    public function insert(int $index, array $item): void{
        $this->innerList->insert($index,$item);
    }

    /**
     * @param int $index
     * @return array
     */
    public function getAt(int $index):array {
        return $this->innerList[$index];
    }

    /**
     * @param int $index
     * @param array $item
     */
    public function setAt(int $index, array $item):void{
        $this->innerList[$index] = $item;
    }

    /**
     * @param int $index
     * @param array ...$items
     */
    public function insertRange(int $index, array ...$items):void{
        $this->innerList->insertRange($index,$items);
    }


    #endregion methods

}
