<?php


namespace Gek\Collections\Typed;


use Gek\Collections\ArrayList;
use Gek\Collections\TypedListWrapper;

/**
 * Class FloatList
 * @package Gek\Collections\Typed
 */
class FloatList extends TypedListWrapper
{

    #region ctor

    /**
     * IntList constructor.
     * @param float ...$items
     */
    public function __construct(float ...$items)
    {
        parent::__construct(new ArrayList(), 'float');
        $this->addRange(...$items);
    }

    #endregion ctor

    #region methods

    /**
     * @param float $item
     */
    public function add(float $item):void{
        $this->innerList->add($item);
    }

    /**
     * @param float ...$items
     */
    public function addRange(float ...$items):void{
        $this->innerList->addRange($items);
    }



    /**
     * @param float $item
     * @return bool
     */
    public function contains(float $item):bool{
        return $this->innerList->contains($item);
    }

    /**
     * @param float  $item
     * @return bool
     */
    public function remove(float $item):bool{
        return $this->innerList->remove($item);
    }

    /**
     * @param float $item
     * @return int
     */
    public function indexOf(float $item): int{
        return $this->innerList->indexOf($item);
    }

    /**
     * @param int $index
     * @param float $item
     */
    public function insert(int $index, float $item): void{
        $this->innerList->insert($index,$item);
    }

    /**
     * @param int $index
     * @return float
     */
    public function getAt(int $index):float {
        return $this->innerList[$index];
    }

    /**
     * @param int $index
     * @param float $item
     */
    public function setAt(int $index, float $item):void{
        $this->innerList[$index] = $item;
    }

    /**
     * @param int $index
     * @param float ...$items
     */
    public function insertRange(int $index, float ...$items):void{
        $this->innerList->insertRange($index,$items);
    }

    #endregion methods

}
